<?php
namespace App\Http\Controllers;

use App\Models\App;
use Illuminate\Http\Request;

class AppController extends Controller
{
    public function index()
    {
        return App::all();
    }

    public function store(Request $request)
    {
        $app = App::create($request->all());
        return response()->json($data, 201);
    }

    public function show($id)
    {
        return App::findOrFail($id);
    }

    public function update(Request $request, $id)
    {
        $app = App::findOrFail($id);
        $app->update($request->all());
        return response()->json($app, 200);
    }

    public function destroy($id)
    {
        App::destroy($id);
        return response()->json(null, 204);
    }
}
