<?php
namespace App\Http\Controllers;

use App\Models\Household;
use App\Models\User;
use App\Models\HouseholdAssignment;
use Illuminate\Http\Request;

class AssignmentController extends Controller
{
    public function showForm()
    {
        // Obtener los hogares y encuestadores disponibles
        $households = Household::all();
        $surveyors = User::where('role_id', 3)->get(); // Filtrar por rol encuestador (suponiendo que el rol de encuestador es 3)

        return view('supervisor.assignments.create', compact('households', 'surveyors'));
    }

    public function assign(Request $request)
    {
        $request->validate([
            'household_id' => 'required|exists:households,id',
            'user_id' => 'required|exists:users,id',
        ]);

        HouseholdAssignment::create([
            'household_id' => $request->input('household_id'),
            'user_id' => $request->input('user_id'),
        ]);

        return redirect()->back()->with('success', 'Hogar asignado exitosamente.');
    }
}
