<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    // Definir el campo de autenticación (username en lugar de email)
    protected function username()
    {
        return 'username';
    }

    // Intentar el inicio de sesión con las credenciales proporcionadas
    protected function attemptLogin(Request $request)
    {
        $credentials = $request->only($this->username(), 'password');
        return $this->guard()->attempt($credentials, $request->filled('remember'));
    }

    /**
     * Redirigir usuarios según su rol después de iniciar sesión.
     *
     * @param \Illuminate\Http\Request $request
     * @param mixed $user
     * @return \Illuminate\Http\RedirectResponse
     */
    protected function authenticated(Request $request, $user)
    {
            return redirect('/'); // Ruta por defecto 
    }

    // Opcionalmente, puedes sobrescribir el logout si necesitas personalizar la redirección
    public function logout(Request $request)
    {
        $this->guard()->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect('/login'); // Redirigir al login después de cerrar sesión
    }
}
