<?php

namespace App\Http\Controllers;

use App\Models\Form;
use Illuminate\Http\Request;

class FormController extends Controller
{
    public function index()
    {
        $forms = Form::all();
        return view('survey.form.index', compact('forms'));
    }

    public function create()
    {
        return view('survey.form.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'form_name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        Form::create($request->all());

        return redirect()->route('forms.index')->with('success', 'Formulario creado exitosamente.');
    }

    public function edit($id)
    {
        $form = Form::findOrFail($id);
        return view('survey.form.edit', compact('form'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'form_name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        $form = Form::findOrFail($id);
        $form->update($request->all());

        return redirect()->route('forms.index')->with('success', 'Formulario actualizado exitosamente.');
    }

    public function destroy($id)
    {
        $form = Form::findOrFail($id);
        $form->delete();

        return redirect()->route('forms.index')->with('success', 'Formulario eliminado exitosamente.');
    }
}
