<?php

// app/Http/Controllers/HouseholdMemberController.php

namespace App\Http\Controllers;

use App\Models\HouseholdMember;
use App\Models\Household;
use App\Imports\HouseholdMembersImport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class HouseholdMemberController extends Controller
{
    public function index(Request $request)
    {
 	$query = HouseholdMember::query();

    	if ($request->filled('correlativo_segmento')) {
            $query->whereHas('household', function($q) use ($request) {
            	$q->where('correlativo_segmento', 'like', '%' . $request->correlativo_segmento . '%');
            });
    	}

    	$members = $query->with(['household' => function($query) {
            $query->select('id', 'correlativo_segmento', 'direccion', 'orden_vivienda', 'numero_vivienda');
        }])->get();

        return view('household_members.index', compact('members'));
    }

    public function create()
    {
        $households = Household::all();
        return view('household_members.create', compact('households'));
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'household_id' => 'required|exists:households,id',
            'numero_de_linea' => 'required|integer',
            'nombre' => 'required|string|max:255',
            'apellido' => 'required|string|max:255',
            'fecha_nacimiento' => 'required|date_format:"m-Y"',
            'edad_dia' => 'required|integer|between:0,30',
            'edad_mes' => 'required|integer|between:0,11',
            'edad_anio' => 'required|integer|min:1',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        HouseholdMember::create($request->all());

        return redirect()->route('household_members.index')
            ->with('success', 'Miembro del hogar creado exitosamente.');
    }

    public function edit(HouseholdMember $householdMember)
    {
        $households = Household::all();
        return view('household_members.edit', compact('householdMember', 'households'));
    }

    public function update(Request $request, HouseholdMember $householdMember)
    {
        $validator = Validator::make($request->all(), [
            'household_id' => 'required|exists:households,id',
            'numero_de_linea' => 'required|integer',
            'nombre' => 'required|string|max:255',
            'apellido' => 'required|string|max:255',
            'fecha_nacimiento' => 'required|date_format:"m-Y"',
            'edad_dia' => 'required|integer|between:0,30',
            'edad_mes' => 'required|integer|between:0,11',
            'edad_anio' => 'required|integer|min:1',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $householdMember->update($request->all());

        return redirect()->route('household_members.index')
            ->with('success', 'Miembro del hogar actualizado exitosamente.');
    }

     public function destroy(HouseholdMember $householdMember)
    {
        $householdMember->delete();

        return redirect()->route('household_members.index')
            ->with('success', 'Miembro del hogar eliminado exitosamente.');
    }
    public function import(Request $request)
    {
	 $request->validate([
            'file' => 'required|mimes:csv,xlsx,xls'
        ]);
        Excel::import(new HouseholdMembersImport, $request->file('file'));
        
    	return redirect()->route('household_members.index')->with('success', 'Miembros del hogar importados con éxito');
    }
    

}

