<?php

// app/Http/Controllers/HouseholdTeamController.php

namespace App\Http\Controllers;

use App\Models\Household;
use App\Models\Segment;
use App\Models\Team;
use App\Models\HouseholdTeam;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HouseholdTeamController extends Controller
{
    public function index()
    {
	// Obtener el último registro de cada correlativo_segmento
        $segmentTeam = HouseholdTeam::select('segment_team.*')
            ->join(
                DB::raw('(SELECT correlativo_segmento, MAX(id) as max_id FROM segment_team GROUP BY correlativo_segmento) as latest'),
                function ($join) {
                    $join->on('segment_team.id', '=', 'latest.max_id');
                }
            )
            ->with('team')
            ->get();
        return view('household_teams.index', compact('segmentTeam'));
    }

    public function create()
    {
        $segments = Segment::where('active', 1)
	    ->whereNotIn('correlativo_segmento', HouseholdTeam::pluck('correlativo_segmento'))
            ->get();
        $teams = Team::all();
        return view('household_teams.create', compact('segments', 'teams'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'correlativo_segmento' => 'required|exists:segments,correlativo_segmento',
            'team_id' => 'required|exists:teams,id',
        ]);

        HouseholdTeam::create([
            'correlativo_segmento' => $request->correlativo_segmento,
            'team_id' => $request->team_id,
            'user_id' => Auth::id(),
            'reassignment_count' => 0
        ]);

        return redirect()->route('household_teams.index')->with('success', 'Household assigned to team successfully.');
    }

    public function reassign($id)
    {
        $householdTeam = HouseholdTeam::findOrFail($id);
        $segments = Segment::where('active', 1)->get();
        $teams = Team::all();
        $currentTeam = Team::findOrFail($householdTeam->team_id);

        return view('household_teams.reassign', compact('householdTeam', 'segments', 'teams', 'currentTeam'));
    }

    public function storeReassign(Request $request, $id)
    {
        $request->validate([
            'team_id' => 'required|exists:teams,id',
        ]);

        $existingHouseholdTeam = HouseholdTeam::findOrFail($id);
	
	$reassignmentCount = $existingHouseholdTeam->reassignment_count ?? 0;
        $reassignmentCount++;
	
	if (is_null($existingHouseholdTeam->reassignment_count)) {
            $reassignmentCount = 1;
        } else {
            $reassignmentCount = $existingHouseholdTeam->reassignment_count + 1;
        }

	HouseholdTeam::create([
            'correlativo_segmento' => $existingHouseholdTeam->correlativo_segmento,
            'team_id' => $request->team_id,
            'user_id' => Auth::id(),
            'team_id_old' => $existingHouseholdTeam->team_id,
            'reassignment_count' => $reassignmentCount,
        ]);

        return redirect()->route('household_teams.index')->with('success', 'Asignación reasignada exitosamente.');
    }
    public function showReassignments($correlativo_segmento)
    {
        $reassignments = HouseholdTeam::where('correlativo_segmento', $correlativo_segmento)
            ->with(['team', 'user'])
            ->orderBy('created_at', 'desc')
            ->get();

        return view('household_teams.show_reassignments', compact('reassignments'));
    }
}
