<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MapPoint;

class MapController extends Controller
{
    public function index()
    {
        $points = MapPoint::all();
        return view('maps.index', compact('points'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|string|max:255',
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',
        ]);

        $point = MapPoint::create($request->all());

        return response()->json(['success' => true, 'data' => $point]);
    }
}
