<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Team;
use App\Models\User;

class TeamController extends Controller
{
    public function index()
    {
        $teams = Team::all();
        return view('teams.index', compact('teams'));
    }

    public function create()
    {
        $users = User::where('role_id', '<>', 1)->get(); // Excluye a los administradores (asumiendo que el rol de admin es 1)
        return view('teams.create', compact('users'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'users' => 'array',
        ]);

        $team = Team::create($request->only('name'));

        if ($request->has('users')) {
            $team->users2()->sync($request->users);
        }

        return redirect()->route('teams.index')
                         ->with('success', 'Team created successfully.');
    }
    public function show(Team $team)
    {
        return view('teams.show', compact('team'));
    }
    public function edit(Team $team)
    {
        $users = User::where('role_id', '<>', 1)->get();
        return view('teams.edit', compact('team', 'users'));
    }

    public function update(Request $request, Team $team)
    {
        $request->validate([
            'name' => 'required',
            'users' => 'array',
        ]);

        $team->update($request->only('name'));

        if ($request->has('users')) {
            $team->users2()->sync($request->users);
        }

        return redirect()->route('teams.index')
                         ->with('success', 'Team updated successfully.');
    }

    public function destroy(Team $team)
    {
        $team->delete();

        return redirect()->route('teams.index')
                         ->with('success', 'Team deleted successfully.');
    }
}
