<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Answer extends Model
{
    use HasFactory;

    protected $table = 'answers';

    protected $fillable = [
        'form_id',
        'unique_code',
        'answers',
        'user_id'
    ];

    // Relación con el modelo Form
    public function form()
    {
        return $this->belongsTo(Form::class);
    }

    // Relación con el modelo User (si es necesario)
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
