<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Canton extends Model
{
    use HasFactory;

    protected $table = 'canton'; // Nombre de la tabla en la base de datos

    protected $fillable = [
        'codigo',
        'nombre',
        'distrito' // Nombre de la columna para el distrito
    ];

    public $timestamps = false; // Si no usas timestamps
    
    public function getAreaAttribute()
    {
        // La lógica determina que si el código es '00' es rural, y cualquier otro código es urbana
        return $this->codigo === '00' ? 'Rural' : 'Urbana';
    }

    /**
     * Relación con la tabla de distritos.
     * Asumiendo que un cantón pertenece a un distrito.
     */
    public function district()
    {
        return $this->belongsTo(District::class, 'district_codigo', 'codigo');
    }
}
