<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model {
 
   use HasFactory;

    // Definir la tabla asociada (opcional si sigue la convención plural)
    protected $table = 'dpto';

    // Definir los campos que se pueden asignar masivamente
    protected $fillable = [
        'codigo', // Código del departamento
        'nombre'  // Nombre del departamento
    ];

    /**
     * Relación con la tabla de regiones.
     * Asumiendo que hay una relación entre departamentos y regiones
     * Si el nombre de la relación es diferente, puedes modificarla.
     */
    public function region()
    {
        return $this->belongsTo(Region::class, 'region_codigo', 'codigo');
    }

   public function muni() {
        return $this->hasMany(Muni::class, 'dpto_codigo', 'codigo');
    }
}
