<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Household extends Model
{
    protected $table = 'households';

    use HasFactory;

    protected $fillable = [
        'correlativo_segmento',
        'region_de_salud',
        'departamento',
        'municipio',
        'distrito',
        'area',
	'direccion',
        'orden_vivienda',
        'numero_vivienda',
	'replacement',
	'status',
        // Los timestamps son manejados automáticamente por Laravel
    ];
    public function members()
    {
        return $this->hasMany(HouseholdMember::class, 'household_id');
    }
}
