<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HouseholdAssignment extends Model
{
    use HasFactory;

    // Especifica la tabla asociada si es diferente al nombre plural del modelo
    protected $table = 'household_assignments';

    // Si no usas timestamps, puedes comentar o eliminar las siguientes líneas
    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';

    // Define los atributos que son asignables en masa
    protected $fillable = [
        'household_id',
        'user_id',
        'form_id',
        'estatus',
    ];

    // Si deseas definir relaciones, puedes hacerlo aquí
     public function household() {
         return $this->belongsTo(Household::class);
     }

    
     public function user() {
         return $this->belongsTo(User::class);
     }

}
