<?php

// app/Models/HouseholdMember.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HouseholdMember extends Model
{
    use HasFactory;

    protected $table = 'household_members';

    protected $fillable = [
        'household_id',
        'numero_de_linea',
        'nombre',
        'edad',
        'sexo',
        'grupo_edad',
	'seleccionado',
    ];

      public function household()
    {
        return $this->belongsTo(Household::class);
    }
    public function getGrupoEdadTextoAttribute()
{
    $grupos = [
        1 => "Madre o responsable",
        2 => "0 a 4 años",
        3 => "5 a 7 años",
        4 => "8 a 11 años",
        5 => "12 a 17 años",
    ];

    return $grupos[$this->grupo_edad] ?? 'Desconocido';
}

public function getSexoTextoAttribute()
{
    $sexo = [
        1 => "Masculino",
        2 => "Femenino",
    ];

    return $sexo[$this->sexo] ?? 'Desconocido';
}

public function getSeleccionadoTextoAttribute()
{
    $seleccionado = [
        1 => "Sí",
        2 => "No",
    ];

    return $seleccionado[$this->seleccionado] ?? 'Desconocido';
}

}

