<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MatrixQuestion extends Model
{
    // Nombre de la tabla asociada al modelo
    protected $table = 'matrix_questions';

    // Los campos que se pueden llenar de forma masiva
    protected $fillable = [
        'question_id',
	'has_other',
    ];

    // Definición de las relaciones

    // Relación con el modelo Question
    public function question()
    {
        return $this->belongsTo(Question::class);
    }

    // Relación con el modelo MatrixRow
    public function rows()
    {
        return $this->hasMany(MatrixRow::class, 'matrix_question_id');
    }

    // Relación con el modelo MatrixColumn
    public function columns()
    {
        return $this->hasMany(MatrixColumn::class, 'matrix_question_id');
    }

    // Relación con el modelo MatrixAnswer
    public function answers()
    {
        return $this->hasMany(MatrixAnswer::class, 'matrix_question_id');
    }
}
