<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    use HasFactory;

    // Tabla asociada
    protected $table = 'questions';

    // Campos que se pueden asignar masivamente
    protected $fillable = [
        'question_text',
        'question_type',
        'is_required',
        'question_code',
        'style_class',
        'condition_id'
    ];

    // Tipo de pregunta
    protected $casts = [
        'is_required' => 'boolean',
    ];

    /**
     * Obtener las respuestas asociadas a esta pregunta.
     */
    public function answers()
    {
        return $this->hasMany(Answer::class, 'question_id');
    }

    /**
     * Obtener la condición asociada a esta pregunta.
     */
    public function condition()
    {
        return $this->belongsTo(Condition::class, 'condition_id');
    }

    /**
     * Obtener las preguntas dependientes asociadas a esta pregunta.
     */
    public function dependentQuestions()
    {
        return $this->hasMany(Condition::class, 'question_id');
    }
    public function options()
    {
     	return $this->hasMany(Option::class);
    }
    public function sections()
    {
        return $this->belongsToMany(Section::class, 'sections_questions', 'question_id', 'section_id');
    }
	
    /**
    * Relación con las preguntas de tipo matriz.
    */
    public function matrixQuestion()
    {
   	 return $this->hasOne(MatrixQuestion::class, 'question_id');
    }
    // En tu modelo de Question
    public function isTextQuestion()
    {
    	return $this->question_type === 'text';
    }

}

