<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use HasFactory;

    protected $fillable = ['name'];

    public function users()
    {
        return $this->hasMany(User::class);
    }
    public function permissions()
    {
        return $this->belongsToMany(Permission::class);
    }
    protected $table = 'roles'; // Nombre de la tabla

    // Si tu tabla tiene un campo "id" que es la clave primaria
    protected $primaryKey = 'id'; 

    // Si no utilizas timestamps en la tabla
    public $timestamps = true; 
}

