<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SectionQuestion extends Model
{
    protected $table = 'sections_questions';

    protected $fillable = [
        'section_id',
        'question_id',
	'question_enum',
        'question_order',
    ];

     public function question()
    {
        return $this->belongsTo(Question::class, 'question_id');
    }

    /**
     * Relación con la tabla FormSection.
     * Cada SectionsQuestion pertenece a una sección.
     */
    public function section()
    {
        return $this->belongsTo(FormSection::class, 'section_id');
    }
}
