<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SectionQuestion extends Model
{
    use HasFactory;

    protected $fillable = [
        'section_id',
        'question_id',
	'question_enum',
        'order'
    ];

    public function section()
    {
        return $this->belongsTo(FormSection::class, 'section_id');
    }

    public function question()
    {
        return $this->belongsTo(Question::class, 'question_id');
    }
}

