<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Segment extends Model
{
    use HasFactory;
 
    protected $table = 'segments'; // Nombre de la tabla en la base de datos

    protected $fillable = [
        'correlativo_segmento',
        'dpto',
        'muni',
        'distrito',
        'canton',
        'active'
    ];
    public function regions() {
        return $this->hasMany(Region::class);
    }
    public function region()
    {
        return $this->hasOne(Region::class, 'codigo', 'region');
    }

    public function departamento()
    {
        return $this->hasOne(Departamento::class, 'codigo', 'dpto');
    }

    public function municipio()
    {
        return $this->hasOne(Muni::class, 'codigo', 'muni');
    }

    public function distrito()
    {
        return $this->hasOne(Distrito::class, 'codigo', 'distrito');
    }

    public function canton()
    {
        return $this->hasOne(Canton::class, 'codigo', 'canton');
    }
    // Si el segmento tiene hogares relacionados
    public function households()
    {
        return $this->hasMany(Household::class, 'correlativo_segmento', 'correlativo_segmento');
    }
}
