<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SegmentUser extends Model
{
    use HasFactory;

    // Nombre de la tabla
    protected $table = 'segment_user';

    // Campos que pueden ser asignados masivamente
    protected $fillable = [
        'correlativo_segmento',
        'user_id',
	'coordinacion',
    ];

    /**
     * Relación con el modelo `User`.
     * Un SegmentUser pertenece a un usuario (coordinador).
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    /**
     * Relación con el modelo `Segment`.
     * Un SegmentUser pertenece a un segmento, basado en el correlativo del segmento.
     */
    public function segment()
    {
        return $this->belongsTo(Segment::class, 'correlativo_segmento', 'correlativo_segmento');
    }
     /**
     * Obtener el nombre de la región a través de la relación con Segment.
     */
    public function getRegionNameAttribute()
    {
        return $this->segment ? $this->segment->region->nombre : null;
    }

    /**
     * Obtener el nombre del departamento a través de la relación con Segment.
     */
    public function getDepartamentoNameAttribute()
    {
        return $this->segment ? $this->segment->departamento->nombre : null;
    }

    /**
     * Obtener el nombre del municipio a través de la relación con Segment.
     */
    public function getMunicipioNameAttribute()
    {
        return $this->segment ? $this->segment->municipio->nombre : null;
    }

    /**
     * Obtener el nombre del distrito a través de la relación con Segment.
     */
    public function getDistritoNameAttribute()
    {
        return $this->segment ? $this->segment->distrito->nombre : null;
    }

    /**
     * Obtener el nombre del área (canton) a través de la relación con Segment.
     */
    public function getAreaNameAttribute()
    {
        return $this->segment ? $this->segment->canton->nombre : null;
    }
}
