<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUsernameToUsersTable extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            // Agrega la columna username solo si no existe
            if (!Schema::hasColumn('users', 'username')) {
                $table->string('username')->nullable()->after('email');
            }
        });

        // Actualizar registros existentes con valores únicos temporales si es necesario
        DB::statement("UPDATE users SET username = CONCAT('user_', id) WHERE username IS NULL OR username = ''");

        // Ahora que todos los registros tienen un username único, podemos establecer la restricción única
        Schema::table('users', function (Blueprint $table) {
            $table->string('username')->unique()->change();
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropUnique(['username']);
            $table->dropColumn('username');
        });
    }
}

