// src/components/QuestionForm.js
import React, { useState, useEffect } from 'react';
import api from '../api/axios';

const QuestionForm = () => {
  const [questions, setQuestions] = useState([]);

  useEffect(() => {
    const fetchQuestions = async () => {
      try {
        const response = await api.get('/questions');
        setQuestions(response.data);
      } catch (error) {
        console.error('Error fetching questions', error);
      }
    };

    fetchQuestions();
  }, []);

  const handleChange = (event) => {
    // Lógica para manejar cambios en el formulario
  };

  return (
    <form>
      {questions.map((question) => (
        <div key={question.id}>
          <h3>{question.text}</h3>
          {question.options.map((option) => (
            <div key={option.id}>
              <input
                type={question.type === 'checkbox' ? 'checkbox' : 'radio'}
                id={option.id}
                name={`question-${question.id}`}
                value={option.value}
                onChange={handleChange}
              />
              <label htmlFor={option.id}>{option.text}</label>
            </div>
          ))}
        </div>
      ))}
      <button type="submit">Enviar</button>
    </form>
  );
};

export default QuestionForm;
