import IMask from 'imask';
import $ from 'jquery';
import 'jquery-validation';
import 'datatables.net-bs5';
import 'datatables.net-responsive-bs5';
import Stepper from 'bs-stepper';

const stepper = new Stepper(document.querySelector('.bs-stepper'), {
    linear: false,
    animation: true
});

document.addEventListener('DOMContentLoaded', function() {

    // Inicializa máscara para el campo p15
    const maskOptions = {
        mask: '0000-0000',
        lazy: false
    };
    ['p15', 'p16', 'p24', 'p27'].forEach(id => {
        const element = document.getElementById(id);
        if (element) {
            new IMask(element, maskOptions);
        }
    });
    // Limpia errores cuando el input recibe foco
    document.querySelectorAll('input').forEach(input => {
        input.addEventListener('focus', function() {
            $(this).next().addClass("active");
	    $(this).closest('.controls').removeClass('has-error');
            $(this).siblings('.help-block').remove();
        });
    });
    window.validateStep = function() {
        var form = $('#form1');
        form.validate({
            errorElement: 'span',
            errorClass: 'help-block',
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.controls').addClass("has-error");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.controls').removeClass("has-error");
            },
            rules: {
                p9: {
                    required: true
                },
                p10: {
                    required: true
                },
                p11: {
                    required: true
                },
                p17: {
                    required: true,
                    email: true
                },
                p23: {
                    required: true,
                    email: true
                }
            },
            messages: {
                p9: {
                    required: "Hora fin es requerida"
                },
                p10: {
                    required: "Nombre de responsable es requerido"
                },
                p11: {
                    required: "Cargo de responsable es requerido"
                },
                p17: {
                    required: "Correo electrónico requerido",
                    email: "Por favor, introduce un correo electrónico válido"
                },
                p23: {
                    required: "Correo electrónico requerido",
                    email: "Por favor, introduce un correo electrónico válido"
                }
            }
        });

        return form.valid();
    };

    // Manejo de validación antes de cambiar de paso
    document.querySelector('.bs-stepper').addEventListener('show.bs-stepper', function(event) {
        const currentIndex = stepper._currentIndex;
        if (currentIndex === undefined || isNaN(currentIndex)) {
            event.preventDefault();
            return;
        }
        if (!validateStep()) {
            event.preventDefault();
        }
    });

    // DataTable si está presente en la vista
    if (document.querySelector('#example')) {
        import('datatables.net-bs5').then(() => {
            import('datatables.net-responsive-bs5').then(() => {
                $('#example').DataTable();
            });
        });
    }
    // Funciones para manejar la navegación
    window.nextStep = function() {
        const currentIndex = stepper._currentIndex;
        if (validateStep()) {
            stepper.next();
        }
    };

    window.previousStep = function() {
        stepper.previous();
    };
   // Etiqueta flotante
    (function($) {
        function floatLabel(inputType) {
            $(inputType).each(function() {
                var $this = $(this);
                // on focus add class active to label
                $this.focus(function() {
                    $this.next().addClass("active");
                });
                // on blur check field and remove class if needed
                $this.blur(function() {
                    if ($this.val() === '' || $this.val() === 'blank') {
                        $this.next().removeClass("active");
                    }
                });
            });
        }
        // just add a class of "floatLabel to the input field!"
        floatLabel(".floatLabel");
    })(jQuery);
});

