import { datosPorRegion } from './ubicaciones.js';

document.addEventListener('DOMContentLoaded', function() {
        const regionSelect = document.getElementById('region');
        const departmentSelect = document.getElementById('depa');
        const municipalitySelect = document.getElementById('muni');
        const districtSelect = document.getElementById('distrito');
        const cantonSelect = document.getElementById('canton');
        const segmentSelect = document.getElementById('segmento');

        function populateSelect(selectElement, options) {
            selectElement.innerHTML = '<option value="">Seleccione una opción</option>';
            options.forEach(option => {
                const optionElement = document.createElement('option');
                optionElement.value = option.value;
                optionElement.textContent = option.label;
                selectElement.appendChild(optionElement);
            });
            selectElement.disabled = options.length === 0;
        }

        function handleRegionChange() {
            const selectedRegion = regionSelect.value;
            const depa = datosPorRegion[selectedRegion] ? Object.keys(datosPorRegion[selectedRegion]).map(depa => ({ value: depa, label: depa })) : [];
            populateSelect(departmentSelect, depa);
            populateSelect(municipalitySelect, []);
            populateSelect(districtSelect, []);
            populateSelect(cantonSelect, []);
            populateSelect(segmentSelect, []);
        }

        function handleDepartmentChange() {
            const selectedDepartment = departmentSelect.value;
            const muni = datosPorRegion[regionSelect.value][selectedDepartment] ? Object.keys(datosPorRegion[regionSelect.value][selectedDepartment]).map(muni => ({ value: muni, label: muni })) : [];
            populateSelect(municipalitySelect, muni);
            populateSelect(districtSelect, []);
            populateSelect(cantonSelect, []);
            populateSelect(segmentSelect, []);
        }

        function handleMunicipalityChange() {
            const selectedMunicipality = municipalitySelect.value;
            const distritos = datosPorRegion[regionSelect.value][departmentSelect.value][selectedMunicipality] ? Object.keys(datosPorRegion[regionSelect.value][departmentSelect.value][selectedMunicipality]).map(distrito => ({ value: distrito, label: distrito })) : [];
            populateSelect(districtSelect, distritos);
            populateSelect(cantonSelect, []);
            populateSelect(segmentSelect, []);
        }

        function handleDistrictChange() {
            const selectedDistrict = districtSelect.value;
            const cantones = datosPorRegion[regionSelect.value][departmentSelect.value][municipalitySelect.value][selectedDistrict] ? Object.keys(datosPorRegion[regionSelect.value][departmentSelect.value][municipalitySelect.value][selectedDistrict]).map(canton => ({ value: canton, label: canton })) : [];
            populateSelect(cantonSelect, cantones);
            populateSelect(segmentSelect, []);
        }

        function handleCantonChange() {
            const selectedCanton = cantonSelect.value;
            const segmentos = datosPorRegion[regionSelect.value][departmentSelect.value][municipalitySelect.value][districtSelect.value][selectedCanton] ? datosPorRegion[regionSelect.value][departmentSelect.value][municipalitySelect.value][districtSelect.value][selectedCanton].map(segmento => ({ value: segmento, label: segmento })) : [];
            populateSelect(segmentSelect, segmentos);
        }

        function handleSegmentChange() {
            const selectedSegment = segmentSelect.value;
            const selectedCanton = Object.keys(datosPorRegion).find(region => Object.keys(datosPorRegion[region]).find(depa => Object.keys(datosPorRegion[region][depa]).find(muni => Object.keys(datosPorRegion[region][depa][muni]).find(distrito => Object.keys(datosPorRegion[region][depa][muni][distrito]).find(canton => Object.keys(datosPorRegion[region][depa][muni][distrito][canton]).includes(selectedSegment))))));
            const selectedDistrict = Object.keys(datosPorRegion[selectedCanton][selectedSegment]);
            const selectedMunicipality = Object.keys(datosPorRegion[selectedCanton][selectedSegment][selectedDistrict]);
            const selectedDepartment = Object.keys(datosPorRegion[selectedCanton][selectedSegment][selectedDistrict][selectedMunicipality]);
            const selectedRegion = Object.keys(datosPorRegion[selectedCanton][selectedSegment][selectedDistrict][selectedMunicipality][selectedDepartment]);

            populateSelect(regionSelect, [{ value: selectedRegion, label: selectedRegion }]);
            populateSelect(departmentSelect, [{ value: selectedDepartment, label: selectedDepartment }]);
            populateSelect(municipalitySelect, [{ value: selectedMunicipality, label: selectedMunicipality }]);
            populateSelect(districtSelect, [{ value: selectedDistrict, label: selectedDistrict }]);
            populateSelect(cantonSelect, [{ value: selectedCanton, label: selectedCanton }]);
        }

        regionSelect.addEventListener('change', handleRegionChange);
        departmentSelect.addEventListener('change', handleDepartmentChange);
        municipalitySelect.addEventListener('change', handleMunicipalityChange);
        districtSelect.addEventListener('change', handleDistrictChange);
        cantonSelect.addEventListener('change', handleCantonChange);
        segmentSelect.addEventListener('change', handleSegmentChange);

        // Inicializa los segmentos
        const segmentOptions = Object.keys(datosPorRegion).flatMap(region => Object.keys(datosPorRegion[region]).flatMap(depa => Object.keys(datosPorRegion[region][depa]).flatMap(muni => Object.keys(datosPorRegion[region][depa][muni]).flatMap(distrito => Object.keys(datosPorRegion[region][depa][muni][distrito]).flatMap(canton => Object.keys(datosPorRegion[region][depa][muni][distrito][canton]))))));
        populateSelect(segmentSelect, segmentOptions);
    });
