@extends('layouts.main')

@push('styles')
    @vite('resources/css/form1.css')
    <link href='https://fonts.googleapis.com/css?family=Lato:300,400' rel='stylesheet' type='text/css'>
@endpush

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header">
              <h5>República de El Salvador</h5>
	      <h5>Despacho de la Primera Dama de El Salvador</h5>
	      <h5>Ministerio de Salud</h5>
	      <h6>Encuesta Nacional de Primera Infancia, Niñez y Adolescencia, El Salvador 2024</h6>
	      <h6>Formulario 1. Coordinación con nivel local previo al levantamiento de datos</h6>
        </div>
        <div class="card-body">
            <div id="stepper" class="bs-stepper">
                <div class="bs-stepper-header" role="tablist">
                    <div class="step" data-target="#test-l-1">
                        <button type="button" class="step-trigger" role="tab" id="steppertrigger1" aria-controls="test-l-1">
                            <span class="bs-stepper-circle">1</span>
                            <span class="bs-stepper-label">Paso 1</span>
                        </button>
                    </div>
                    <div class="line"></div>
                    <div class="step" data-target="#test-l-2">
                        <button type="button" class="step-trigger" role="tab" id="steppertrigger2" aria-controls="test-l-2">
                            <span class="bs-stepper-circle">2</span>
                            <span class="bs-stepper-label">Paso 2</span>
                        </button>
                    </div>
                    <div class="line"></div>
                    <div class="step" data-target="#test-l-3">
                        <button type="button" class="step-trigger" role="tab" id="steppertrigger3" aria-controls="test-l-3">
                            <span class="bs-stepper-circle">3</span>
                            <span class="bs-stepper-label">Paso 3</span>
                        </button>
                    </div>
                    <div class="line"></div>
                    <div class="step" data-target="#test-l-4">
                        <button type="button" class="step-trigger" role="tab" id="steppertrigger4" aria-controls="test-l-4">
                            <span class="bs-stepper-circle">4</span>
                            <span class="bs-stepper-label">Paso 4</span>
                        </button>
                    </div>
                </div>
                <div class="bs-stepper-content">
                    <form id="form1">
			<div id="test-l-1" class="content" role="tabpanel" aria-labelledby="steppertrigger1">
			<h2 class="heading">DATOS DEL SEGMENTO Y RESPONSABLE</h2>
                        <div class="grid">
			<div class="col-1-2 col-1-4-sm">
			    <div class="controls">
			      <i class="bx bx-sort"></i>
			      <select class="floatLabel" id="p1" name="p1" required>
			        <option value=""></option>
			      </select>
			      <label for="p1" id="p1lbl">1. Correlativo de segmento</label>
			     </div> 
			</div>
              		<div class="col-1-2 col-1-4-sm">
		     	   <div class="controls">
			       <i class="bx bx-sort"></i>
			       <select class="floatLabel" id="p2" name="p2" required>
				  <option value="blank"></option>
			        </select>
			        <label for="p2" id="p2lbl">2. Región de salud</label>
		           </div>
		        </div>
            		</div>
			<div class="grid">
                        <div class="col-1-2 col-1-4-sm">
                            <div class="controls">
                              <i class="bx bx-sort"></i>
                              <select class="floatLabel" id="p3" name="p3" required>
                                <option value=""></option>
                              </select>
                              <label for="p3" id="p3lbl">3. Departamento</label>
                             </div>
                        </div>
                        <div class="col-1-2 col-1-4-sm">
                           <div class="controls">
                               <i class="bx bx-sort"></i>
                               <select class="floatLabel" id="p4" name="p4" required>
                                  <option value="blank"></option>
                                </select>
                                <label for="p4" id="p4lbl">4. Municipio</label>
                           </div>
                        </div>
                        </div>
			<div class="grid">
                        <div class="col-1-2 col-1-4-sm">
                            <div class="controls">
                              <i class="bx bx-sort"></i>
                              <select class="floatLabel" id="p5" name="p5" required>
                                <option value=""></option>
                              </select>
                              <label for="p5" id="p5lbl">5. Distrito</label>
                             </div>
                        </div>
                        <div class="col-1-2 col-1-4-sm">
                           <div class="controls">
                               <i class="bx bx-sort"></i>
                               <select class="floatLabel" id="p6" name="p6" required>
                                  <option value="blank"></option>
                                </select>
                                <label for="p6" id="p6lbl">6. Área</label>
                           </div>
                        </div>
                        </div>
			<div class="grid">
                        <div class="col-1-3 col-1-3-sm">
                            <div class="controls">
                              <input type="date" id="p7" class="floatLabel" name="p7" value="<?php echo date('Y-m-d'); ?>" required>
                              <label for="p7" class="label-date"><i class="bx bx-calendar"></i>&nbsp;&nbsp;7. Fecha de coordinación</label>
                             </div>
                        </div>
			<div class="col-1-3 col-1-3-sm">
                           <div class="controls">
                               <input type="time" id="p8" class="floatLabel" name="p8" value="<?php $dt = new DateTime('now', new DateTimeZone('America/El_Salvador')); echo $dt->format('H:i'); ?>" disabled>
                               <label for="p8" class="label-date active"><i class="bx bx-time"></i>&nbsp;&nbsp;8. Hora de inicio</label>
                           </div>
                        </div>
                         <div class="col-1-3 col-1-3-sm">
                            <div class="controls">
                               <input type="time" id="p9" class="floatLabel" name="p9" min="06:00" max="18:00" required>
                               <label for="p9" class="label-date"><i class="bx bx-time"></i>&nbsp;&nbsp;9. Hora de finalización</label>
                           </div>
                        </div>
			</div>
			<div class="grid">
                        <div class="col-1-2 col-1-4-sm">
                            <div class="controls">
                              <input type="text" id="p10" class="floatLabel" name="p10" value="{{ $user->name }}" readonly>
                              <label for="p10" class="active">10. Nombre responsable</label>
                             </div>
                        </div>
                        <div class="col-1-2 col-1-4-sm">
                           <div class="controls">
                               <input type="text" id="p11" class="floatLabel" name="p11" value="{{ $user->cargo }}" required>
                               <label for="p11" class="active">11. Cargo</label>
                           </div>
                        </div>
                        </div>
                        <button type="button" class="btn btn-primary next" onclick="nextStep()">Siguiente</button>
                        </div>
                        <div id="test-l-2" class="content" role="tabpanel" aria-labelledby="steppertrigger2">
                           <h2 class="heading">DATOS DE JEFATURA POR INSTITUCIÓN</h2>
                        <div class="grid">
                        <div class="col-12">
                            <div class="controls">
                              <i class="bx bx-sort"></i>
                              <select class="floatLabel" id="p12" name="p12" required>
                                <option value=""></option>
				<option value="1">Minsal</option>
				<option value="2">Alcaldía</option>
				<option value="3">ADESCO</option>
				<option value="4">ONG</option>
				<option value="5">Líder comunal</option>
				<option value="6">Otro</option>
                              </select>
                              <label for="p12">12. Institución</label>
                             </div>
                        </div>
			<div class="col-6 col-6-sm" style="display:none;">
                           <div class="controls">
                               <input type="text" id="p12_1" class="floatLabel" name="p12_1">
                               <label for="p12_1">Detalle Otro</label>
                           </div>
                        </div>
			</div>
			<div class="grid">
                        <div class="col-1-2 col-1-4-sm">
                           <div class="controls">
                               <input type="text" id="p13" class="floatLabel" name="p13">
                               <label for="p13">13. Nombre de establecimiento</label>
                           </div>
                        </div>
			<div class="col-1-2 col-1-4-sm">
                           <div class="controls">
                               <input type="text" id="p14" class="floatLabel" name="p14">
                               <label for="p14">14. Nombre de jefatura</label>
                           </div>
                        </div>
                        </div>
			<div class="grid">
                        <div class="col-1-2 col-1-4-sm">
                            <div class="controls">
                              <input type="text" id="p15" class="floatLabel" name="p15" placeholder="_____-_____" pattern="[2]{1}[0-9]{3}-[0-9]{4}" max-length="9">
                              <label for="p15">15. Teléfono fijo</label>
                             </div>
                        </div>
                        <div class="col-1-2 col-1-4-sm">
                           <div class="controls">
                               <input type="text" id="p16" class="floatLabel" name="p16" placeholder="_____-_____" pattern="[6-7]{1}[0-9]{3}-[0-9]{4}" max-length="9">
                               <label for="p16">16. Teléfono móvil</label>
                           </div>
                        </div>
                        </div>
			<div class="grid">
			<div class="col-12">
                           <div class="controls">
                               <input type="email" id="p17" class="floatLabel" name="p17">
                               <label for="p17">17. Correo electrónico</label>
                           </div>
                        </div>
                        </div>
                        <button type="button" class="btn btn-primary prev" onclick="previousStep()">Anterior</button>
                        <button type="button" class="btn btn-primary next" onclick="nextStep()">Siguiente</button>
                        </div>
                        <div id="test-l-3" class="content" role="tabpanel" aria-labelledby="steppertrigger3">
                        <h2 class="heading">DATOS DE PERSONAL DESIGNADO PARA APOYAR</h2>
                        <div class="grid">
                        <div class="col-12">
                            <div class="controls">
                              <i class="bx bx-sort"></i>
                              <select class="floatLabel" id="p18" name="p18">
                                <option value=""></option>
                                <option value="1">Minsal</option>
                                <option value="2">Alcaldía</option>
                                <option value="3">ADESCO</option>
                                <option value="4">ONG</option>
                                <option value="5">Líder comunal</option>
                                <option value="6">Otro</option>
                              </select>
                              <label for="p18">18. Institución</label>
                             </div>
                        </div>
                        <div class="col-6 col-6-sm" style="display:none;">
                           <div class="controls">
                               <input type="text" id="p18_1" class="floatLabel" name="p18_1">
                               <label for="p18_1">Detalle Otro</label>
                           </div>
                        </div>
			</div>
                        <div class="grid">
                        <div class="col-1-2 col-1-4-sm">
                           <div class="controls">
                               <input type="text" id="p19" class="floatLabel" name="p19">
                               <label for="p19">19. Nombre de establecimiento</label>
                           </div>
                        </div>
                        <div class="col-1-2 col-1-4-sm">
                           <div class="controls">
                               <input type="text" id="p20" class="floatLabel" name="p20">
                               <label for="p20">20. Nombre de jefatura</label>
                           </div>
                        </div>
                        </div>
			<div class="grid">
                        <div class="col-1-2 col-1-4-sm">
                            <div class="controls">
                              <input type="text" id="p21" class="floatLabel" name="p21" placeholder="_____-_____" pattern="[2]{1}[0-9]{3}-[0-9]{4}" max-length="9">
                              <label for="p21">21. Teléfono fijo</label>
                             </div>
                        </div>
                        <div class="col-1-2 col-1-4-sm">
                           <div class="controls">
                               <input type="text" id="p22" class="floatLabel" name="p22" placeholder="_____-_____" pattern="[6-7]{1}[0-9]{3}-[0-9]{4}" max-length="9">
                               <label for="p22">22. Teléfono móvil</label>
                           </div>
                        </div>
                        </div>
                        <div class="grid">
                        <div class="col-12">
                           <div class="controls">
                               <input type="email" id="p23" class="floatLabel" name="p23">
                               <label for="p23">23. Correo electrónico</label>
                           </div>
                        </div>
                        </div>

                            <button type="button" class="btn btn-primary prev" onclick="previousStep()">Anterior</button>
                            <button type="button" class="btn btn-primary next" onclick="nextStep()">Siguiente</button>
                        </div>
                        <div id="test-l-4" class="content" role="tabpanel" aria-labelledby="steppertrigger4">
                             <h2 class="heading">DATOS DE PERSONAL DE LABORATORIO Y PROMOTOR(A) DE SALUD</h2>
                        <div class="grid">
                        <fieldset>
			    <legend>24. En la unidad de salud hay laboratorio clínico:</legend>
			    <div class="grid-header">
                    	    <div class="header-item">Si</div>
                    	    <div class="header-item">No</div>
                  	    </div>
                  	    <div class="grid-row">
                    	    <label class="flex-item">
                      	    <input type="radio" value="1" name="p24" id="p24_1" onchange="mostrarJefeLaboratorio()"> <span></span>
                    	    </label>
                    	    <label class="flex-item">
                      	    <input type="radio" value="2" name="p24" id="p24_2" onchange="mostrarJefeLaboratorio2()"> <span></span>
                    	    </label>
                  	    </div>
			   <div class="grid" style="display:none; ">
	                        <div class="col-1-2 col-1-4-sm">
                           	<div class="controls">
                               	<input type="text" id="p25" class="floatLabel" name="p25">
                               	<label for="p2">25. Nombre de jefe(a) de laboratorio:</label>
                           	</div>
                        	</div>
                            </div>

			  </fieldset>
                        </div>
			<div class="grid">
                        <fieldset>
                            <legend>27. En el área a trabajar hay promotor(a) de Salud responsable del área:</legend>
                            <div class="grid-header">
                            <div class="header-item">Si</div>
                            <div class="header-item">No</div>
                            </div>
                            <div class="grid-row">
                            <label class="flex-item">
                            <input type="radio" value="1" name="p27" id="p27_1" onchange="mostrarPromotor()"> <span></span>
                            </label>
                            <label class="flex-item">
                            <input type="radio" value="2" name="p27" id="p27_2" onchange="mostrarPromotor2()"> <span></span>
                            </label>
                            </div>
                          </fieldset>
                        </div>

                            <button type="button" class="btn btn-primary prev" onclick="previousStep()">Anterior</button>
                            <button type="submit" class="btn btn-success next">Finalizar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
    @vite(['resources/js/form1.js','resources/js/populateSelect2.js'])
   <script>
        $(document).ready(function() {
            $('#p1').select2({
                placeholder: "Seleccione el segmento",
                allowClear: true
            }).on('change', function(){
                var selectedValue = $(this).val();
		console.log("Valor de segmento:", selectedValue);
                // on focus add class active to label
                if(selectedValue){
		   $('#p1lbl').addClass('active');
		   $('#p2lbl').addClass('active');
		   $('#p3lbl').addClass('active');
		   $('#p4lbl').addClass('active');
		   $('#p5lbl').addClass('active');
                   $('#p6lbl').addClass('active'); 
		}else{
		   $('#p1lbl').removeClass('active');
                   $('#p2lbl').removeClass('active');
                   $('#p3lbl').removeClass('active');
                   $('#p4lbl').removeClass('active');
		   $('#p5lbl').removeClass('active');
                   $('#p6lbl').removeClass('active');

		}
            });
        });
   </script>

@endpush
