@extends('layouts.main')
@section('content')
<div class="dashboard-container">
    <!-- Contenedor 1: Hogares y Miembros -->
    <div class="container-horizontal">
    <div class="row py-5">
    <div class="col-12">
    <div id="segmentos">
            <!-- Contenido de Hogares -->

    <div class="d-flex justify-content-between align-items-center">
        <h3>Datos del hogar a visitar</h3>
        <!-- Botón de Editar en la parte superior derecha -->
        <a href="#" class="btn btn-outline-secondary edit-btn"><i class='bx bxs-edit'></i> Editar</a>
    </div>
    
    @if(!$seccion1['p9'])
        <a href="{{ route('survey.show', ['id' => 1]) }}" class="btn btn-primary">Completar formulario 1</a>
    @endif
     <table id="answerTable" class="table table-hover responsive nowrap" style="width:100%">
        <thead>
            <tr>
                <th>Pregunta</th>
                <th>Respuesta</th>
            </tr>
        </thead>
        <tbody>
            @if(isset($seccion1))
                <tr>
                    <td>Correlativo de segmento:</td>
                    <td>{{ $seccion1['p1']  }}</td>
		</tr>
		<tr>
                    <td>Región:</td>
                    <td>{{ $seccion1['p2']  }}</td>
                </tr>
		<tr>
                    <td>Departamento:</td>
                    <td>{{ $seccion1['p3']  }}</td>
                </tr>
		<tr>
                    <td>Municipio:</td>
                    <td>{{ $seccion1['p4']  }}</td>
                </tr>
		<tr>
                    <td>Distrito:</td>
                    <td>{{ $seccion1['p5'] }}</td>
                </tr>
		<tr>
                    <td>Área:</td>
                    <td>{{ $seccion1['p6']  }}</td>
                </tr>
		<tr>
                    <td>Nombre del supervisor de Gestión Local:</td>
                    <td>{{ $seccion1['p7']  }}</td>
                </tr>
		<tr>
                    <td>Fecha de visita y levantamiento de datos:</td>
                    <td>{{ $seccion1['p8']  }}</td>
                </tr>
		<tr>
                    <td>Hora de inicio:</td>
                    <td>{{ $seccion1['p9']  }}</td>
                </tr>
		 <tr>
                    <td>Hora de finalización:</td>
                    <td>{{ $seccion1['p10']  }}</td>
                </tr>

             @else
	        <tr>
		    <td>No hay datos disponibles para este segmento.</td>
		</tr>
    	     @endif

        </tbody>
    </table>
    <!-- Sección 2: Personal Designado para Apoyar -->
                    @if(isset($seccion2) && !empty($seccion2))
                        <h3 class="mt-5">Sección 2: Personal Designado para Apoyar</h3>
                        <table id="seccion2Table" class="table table-hover responsive nowrap" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Número</th>
                                    <th>Nombre completo</th>
                                    <th>Institución</th>
                                    <th>Teléfono fijo</th>
                                    <th>Teléfono móvil</th>
                                    <th>Correo electrónico</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($seccion2 as $persona)
                                    <tr>
                                        <td>{{ $persona['p11'] }}</td>
                                        <td>{{ $persona['p12'] ?? 'No registrado' }}</td>
                                        <td>{{ $persona['p13'] }}</td>
                                        <td>{{ $persona['p14'] }}</td>
                                        <td>{{ $persona['p15'] }}</td>
                                        <td>{{ $persona['p16'] }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p>No hay personal designado para apoyar registrado.</p>
                    @endif

                    <!-- Sección 3 -->
                    @if(isset($seccion3))
                        <h3 class="mt-5">Sección 3</h3>
                        <p>Aquí se mostrarán los datos de la sección 3 cuando estén disponibles...</p>
                    @else
                        <p>No hay datos disponibles en la Sección 3.</p>
                    @endif

                    <!-- Sección 4 -->
                    @if(isset($seccion4))
                        <h3 class="mt-5">Sección 4</h3>
                        <table id="seccion4Table" class="table table-hover responsive nowrap" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Pregunta</th>
                                    <th>Respuesta</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>p24:</td>
                                    <td>{{ $seccion4['p24'] }}</td>
                                </tr>
                                <tr>
                                    <td>Nombre del jefe de laboratorio:</td>
                                    <td>{{ $seccion4['p25'] }}</td>
                                </tr>
                                <tr>
                                    <td>Teléfono móvil:</td>
                                    <td>{{ $seccion4['p26'] }}</td>
                                </tr>
                                <tr>
                                    <td>Correo electrónico:</td>
                                    <td>{{ $seccion4['p27'] }}</td>
                                </tr>
                                <tr>
                                    <td>En el área a trabajar hay promotor(a) de salud:</td>
                                    <td>{{ $seccion4['p28'] == '1' ? 'Sí' : 'No' }}</td>
                                </tr>
                                <tr>
                                    <td>Nombre del promotor de salud:</td>
                                    <td>{{ $seccion4['p29'] }}</td>
                                </tr>
                                <tr>
                                    <td>Teléfono móvil:</td>
                                    <td>{{ $seccion4['p30'] }}</td>
                                </tr>
                                <tr>
                                    <td>Correo electrónico:</td>
                                    <td>{{ $seccion4['p31'] }}</td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <p>No hay datos disponibles en la Sección 4.</p>
                    @endif

                    <!-- Sección 5 -->
                    @if(isset($seccion5))
                        <h3 class="mt-5">Sección 5</h3>
                        <table id="seccion5Table" class="table table-hover responsive nowrap" style="width:100%">
                            <thead>
                                <tr>
                                    <th>Pregunta</th>
                                    <th>Respuesta</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Resultado final de la coordinación:</td>
                                    <td>{{ $seccion5['p32'] }}</td>
                                </tr>
                            </tbody>
                        </table>
		    @else
                        <p>No hay datos disponibles en la Sección 5.</p>
                    @endif
</div>
        </div>
        </div>
    </div>

</div>
@endsection
