<!-- resources/views/household_teams/create.blade.php -->

@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Asignar Segmento a Equipo</h1>
    <form action="{{ route('household_teams.store') }}" method="POST">
        @csrf
        <div class="form-group">
            <label for="correlativo_segmento">Segmento</label>
            <select name="correlativo_segmento" id="correlativo_segmento" class="form-control">
                @foreach($segments as $segment)
                    <option value="{{ $segment->correlativo_segmento }}">{{ $segment->correlativo_segmento }}</option>
                @endforeach
            </select>
        </div>
        <div class="form-group">
            <label for="team_id">Equipo</label>
            <select name="team_id" id="team_id" class="form-control">
                @foreach($teams as $team)
                    <option value="{{ $team->id }}">{{ $team->name }}</option>
                @endforeach
            </select>
        </div>
        <button type="submit" class="btn btn-success">Asignar</button>
    </form>
</div>
@endsection
