<!-- resources/views/household_teams/edit.blade.php -->

@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Edit Household Assignment</h1>
    <form action="{{ route('household_teams.update', $householdTeam->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="form-group">
            <label for="household_id">Household</label>
            <select name="household_id" id="household_id" class="form-control">
                @foreach($households as $household)
                    <option value="{{ $household->id }}" {{ $householdTeam->household_id == $household->id ? 'selected' : '' }}>{{ $household->numero_vivienda }}</option>
                @endforeach
            </select>
        </div>
        <div class="form-group">
            <label for="team_id">Team</label>
            <select name="team_id" id="team_id" class="form-control">
                @foreach($teams as $team)
                    <option value="{{ $team->id }}" {{ $householdTeam->team_id == $team->id ? 'selected' : '' }}>{{ $team->name }}</option>
                @endforeach
            </select>
        </div>
        <button type="submit" class="btn btn-success">Update</button>
    </form>
</div>
@endsection
