<!-- resources/views/household_teams/show_reassignments.blade.php -->

@extends('layouts.main')

@section('content')
<div class="container">
    <h2>Historial de Reasignaciones para el Segmento {{ $reassignments->first()->correlativo_segmento }}</h2>
    <table id="reassignmentsTable" class="table table-bordered table-hover">
        <thead>
            <tr>
                <th>Segmento</th>
                <th>Equipo</th>
                <th>Usuario</th>
                <th>Fecha de Reasignación</th>
            </tr>
        </thead>
        <tbody>
            @foreach($reassignments as $reassignment)
                <tr>
                    <td>{{ $reassignment->correlativo_segmento }}</td>
                    <td>{{ $reassignment->team->name }}</td>
                    <td>{{ $reassignment->user->name }}</td>
                    <td>{{ $reassignment->created_at }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<script>
    $(document).ready(function() {
        $('#reassignmentsTable').DataTable({
            "responsive": true,
            "autoWidth": false,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.21/i18n/Spanish.json"
            }
        });
    });
</script>
@endsection
