@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Agregar Household</h1>
    <form method="POST" action="{{ route('households.store') }}">
        @csrf
        
        <div class="mb-3">
            <label for="correlativo_segmento" class="form-label">Correlativo Segmento</label>
            <select class="form-control select2" id="correlativo_segmento" name="correlativo_segmento">
                @foreach($segments as $segment)
                    <option value="{{ $segment->correlativo_segmento }}">{{ $segment->correlativo_segmento }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="region" class="form-label">Región</label>
            <select class="form-control" id="region" name="region">
                @foreach($regions as $region)
                    <option value="{{ $region->codigo }}">{{ $region->nombre }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="departamento" class="form-label">Departamento</label>
            <select class="form-control" id="departamento" name="departamento">
                <!-- Las opciones se cargarán de forma dinámica según la región seleccionada -->
            </select>
        </div>

        <!-- Otros campos del formulario aquí -->

        <button type="submit" class="btn btn-primary">Agregar</button>
    </form>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#region').change(function() {
            let regionCode = $(this).val();
            
            // Cargar departamentos basados en la región seleccionada
            $.ajax({
                url: '/api/departamentos/by-region', // Ruta a la API que devuelve los departamentos
                data: { region: regionCode },
                success: function(data) {
                    $('#departamento').empty();
                    $.each(data, function(key, value) {
                        $('#departamento').append('<option value="'+ value.codigo +'">'+ value.nombre +'</option>');
                    });
                }
            });
        });
    });
</script>
@endpush
