
@extends('layouts.main')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                <div class="row">
                    <div class="col-12">
                        <div id="segmentos">
                            <!-- Contenido de Hogares -->
                            <div class="row">
                                <div class="col-lg-12 margin-tb">
                                <div class="pull-left">
				    <h1>Listado de hogares</h1>
				</div>
				<div class="pull-right">
                                    <!-- Formulario de importación de Households -->
        			    <form action="{{ route('households.import') }}" method="POST" enctype="multipart/form-data">
        		    	        @csrf
            				<div class="form-group">
            				    <label for="file">Importar Households</label>
            				    <input type="file" name="file" class="form-control">
            				</div>
            				<button type="submit" class="btn btn-success mt-2">Importar</button>
			            </form>
                                </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                </div>
                <div class="card-body">
    		    <table id="householdTable" class="table table-hover responsive nowrap" style="width:100%">
        		<thead>
            	    	   <tr>
                		<th>#</th>
                		<th>C. Segmento</th>
                		<th>Región</th>
                		<th>Depto</th>
                		<th>Municipio</th>
                		<th>Distrito</th>
                		<th>Área</th>
				<th>Dirección</th>
                		<th>Or Viv</th>
                		<th>No Viv</th>
				<th>Detalle</th>
                		<th>Acciones</th>
            		   </tr>
        		</thead>
        		<tbody>
            		    @foreach($households as $household)
           		    <tr>
                		<td>{{ $household->id }}</td>
                		<td>{{ $household->correlativo_segmento }}</td>
                		<td>{{ $household->region_de_salud }}</td>
		                <td>{{ $household->departamento }}</td>
		                <td>{{ $household->municipio }}</td>
		                <td>{{ $household->distrito }}</td>
        		        <td>{{ $household->area }}</td>
				<td>{{ $household->direccion }}</td>
		                <td>{{ $household->orden_vivienda }}</td>
		                <td>{{ $household->numero_vivienda }}</td>
				<td>{{ $household->replacement }}</td>
		            	<td>
                    		    <a href="{{ route('households.edit', $household->id) }}" class="btn btn-warning"><i class='bx bx-edit'></i></a>
                    		    <form action="{{ route('households.destroy', $household->id) }}" method="POST" style="display:inline;">
                        	    	@csrf
                             	    	@method('DELETE')
                        	    	<button type="submit" class="btn btn-danger"><i class='bx bx-trash'></i></button>
                    		    </form>
                		</td>
            		    </tr>
           		    @endforeach
        		</tbody>
    		    </table>
		</div>
	    </div>
	</div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {

    $('#householdTable').DataTable({
        language: {
                url: '/js/i18n/es-MX.json'
        },
        pagingType: "simple_numbers",
        scrollX: true,
        dom: '<"top"f>rt<"bottom"lip><"clear">',
        bootstrap: true,
        paging: true,
        responsive: false, // Desactivar el responsive para evitar el botón de "+"
        autoWidth: false,
    });
});
</script>
@endpush

