@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Mapa</h1>
    <div id="map" style="height: 500px;"></div>
</div>

<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        var map = L.map('map').setView([51.505, -0.09], 13);

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19
        }).addTo(map);

        var points = @json($points);

        points.forEach(function (point) {
            var icon = L.icon({
                iconUrl: getIconUrl(point.type),
                iconSize: [32, 32]
            });

            L.marker([point.latitude, point.longitude], { icon: icon }).addTo(map)
                .bindPopup('<b>' + point.name + '</b><br>' + point.type).openPopup();
        });

        function getIconUrl(type) {
            switch (type) {
                case 'vivienda ocupada':
                    return '/path/to/vivienda_ocupada_icon.png';
                case 'vivienda estacional':
                    return '/path/to/vivienda_estacional_icon.png';
                case 'vivienda desocupada':
                    return '/path/to/vivienda_desocupada_icon.png';
                // Agrega más casos según sea necesario
                default:
                    return '/path/to/default_icon.png';
            }
        }

        // Capturar clics en el mapa
        map.on('click', function(e) {
            var lat = e.latlng.lat;
            var lng = e.latlng.lng;

            var popupContent = '<form id="popup-form">' +
                '<div class="form-group">' +
                '<label for="name">Nombre</label>' +
                '<input type="text" class="form-control" id="name" name="name" required>' +
                '</div>' +
                '<div class="form-group">' +
                '<label for="type">Tipo</label>' +
                '<input type="text" class="form-control" id="type" name="type" required>' +
                '</div>' +
                '<input type="hidden" id="latitude" name="latitude" value="' + lat + '">' +
                '<input type="hidden" id="longitude" name="longitude" value="' + lng + '">' +
                '<button type="submit" class="btn btn-primary">Guardar</button>' +
                '</form>';

            var popup = L.popup()
                .setLatLng(e.latlng)
                .setContent(popupContent)
                .openOn(map);

            document.getElementById('popup-form').addEventListener('submit', function(event) {
                event.preventDefault();

                var formData = new FormData(event.target);

                fetch('{{ route("maps.store") }}', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Añadir el nuevo punto al mapa
                        var newIcon = L.icon({
                            iconUrl: getIconUrl(formData.get('type')),
                            iconSize: [32, 32]
                        });

                        L.marker([lat, lng], { icon: newIcon }).addTo(map)
                            .bindPopup('<b>' + formData.get('name') + '</b><br>' + formData.get('type')).openPopup();

                        map.closePopup();
                    }
                })
                .catch(error => console.error('Error:', error));
            });
        });
    });
</script>
@endsection

