@extends('layouts.main')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="card">
                <div class="card-header">Asignar Segmento a Coordinador</div>

                <div class="card-body">
                    <form method="POST" action="{{ route('segment_user.store') }}">
                        @csrf

                        <div class="row g-3">
                            <!-- Campo para seleccionar el correlativo_segmento -->
                            <div class="col-md-6">
                                <label for="correlativo_segmento" class="form-label">Correlativo Segmento</label>
                                <select id="correlativo_segmento" name="correlativo_segmento" class="form-select" required>
                                    <option value="" selected disabled>Seleccione un segmento</option>
                                    @foreach($segments as $segment)
                                        <option value="{{ $segment->correlativo_segmento }}">
                                            {{ $segment->correlativo_segmento }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <!-- Campo para seleccionar el coordinador -->
                            <div class="col-md-6">
                                <label for="user_id" class="form-label">Coordinador</label>
                                <select id="user_id" name="user_id" class="form-select" required>
                                    <option value="" selected disabled>Seleccione un coordinador</option>
                                    @foreach($coordinators as $coordinator)
                                        <option value="{{ $coordinator->id }}">
                                            {{ $coordinator->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
			    <div class="col-md-12">
                                <label for="coordinacion" class="form-label">Segmento requiere información del Personal</label>
                                <select id="coordinacion" name="coordinacion" class="form-select" required>
                                    <option value="" selected disabled>Seleccione un coordinador</option>
				    <option value="1">Si</option>
                                    <option value="0">No</option>
                                </select>
                            </div>

                            <!-- Botón para enviar el formulario -->
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Asignar Segmento</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
