@extends('layouts.main')

@section('content')
<div class="container">
    <h1 class="mt-4">Editar Asignación de Segmento</h1>
    
    <div class="card">
        <div class="card-body">
            <form action="{{ route('segment-user.update', $segmentUser->id) }}" method="POST" class="row g-3">
                @csrf
                @method('PUT')

                <!-- Correlativo Segmento -->
                <div class="col-md-6">
                    <label for="correlativo_segmento" class="form-label">Correlativo Segmento</label>
                    <select id="correlativo_segmento" name="correlativo_segmento" class="form-select" required>
                        <option value="">Seleccione un segmento</option>
                        @foreach($segments as $segment)
                            <option value="{{ $segment->correlativo_segmento }}" 
                                {{ $segmentUser->correlativo_segmento == $segment->correlativo_segmento ? 'selected' : '' }}>
                                {{ $segment->correlativo_segmento }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Coordinador -->
                <div class="col-md-6">
                    <label for="user_id" class="form-label">Coordinador</label>
                    <select id="user_id" name="user_id" class="form-select" required>
                        <option value="">Seleccione un coordinador</option>
                        @foreach($coordinators as $coordinator)
                            <option value="{{ $coordinator->id }}" 
                                {{ $segmentUser->user_id == $coordinator->id ? 'selected' : '' }}>
                                {{ $coordinator->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
		<div class="col-md-12">
                      <label for="coordinacion" class="form-label">Segmento requiere información del Personal</label>
                      <select id="coordinacion" name="coordinacion" class="form-select" required>
                            <option value="">Seleccione un segmento</option>
                            	    <option value="{{ $segmentUser->coordinacion }}"
                                	<option value="1" {{ $segmentUser->coordinacion == 1 ? 'selected' : '' }}>Sí</option>
			                <option value="0" {{ $segmentUser->coordinacion == 0 ? 'selected' : '' }}>No</option>
                            	    </option>

                      </select>
                 </div>

                <!-- Botones de Acción -->
                <div class="col-12 d-flex justify-content-end">
                    <a href="{{ route('segment_user.index') }}" class="btn btn-secondary me-2">Cancelar</a>
                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
