@extends('layouts.main')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="card">
                <div class="card-header">
                    <div class="row">
            		<div class="col-lg-12 margin-tb">
            		    <div class="pull-left">
              		        <h2>Segmentos asignados a supervisor de gestión local</h2>
                	    </div>
                	    <div class="pull-right">
                		<a href="{{ route('segment_user.create') }}" class="btn btn-outline-dark">
		   	          <i class='bx bxs-user-plus'></i>  Asignar Segmento
        			</a>
                	    </div>
               		</div>
        	    </div>
                </div>

                <div class="card-body">
                    <table id="segment-users-table" class="table table-hover responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Correlativo Segmento</th>
                                <th>Nombre de coordinador</th>
                                <th>Fecha de asignación</th>
				<th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($segmentUsers as $key => $segmentUser)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $segmentUser->correlativo_segmento }}</td>
                                    <td>{{ $segmentUser->user->name }}</td>
                                    <td>{{ $segmentUser->created_at->format('d-m-Y H:i') }}</td>
				    <td>
                                	<!-- Botón de Editar -->
                                	<a href="{{ route('segment-user.edit', $segmentUser->id) }}" class="btn btn-sm btn-warning" title="Editar">
                                	    <i class="bx bx-edit-alt"></i> <!-- Icono de editar -->
                                	</a>
                                
                                	<!-- Botón de Eliminar -->
                                	<form action="{{ route('segment-user.destroy', $segmentUser->id) }}" method="POST" style="display:inline-block;">
                                    	    @csrf
                                    	    @method('DELETE')
                                    	    <button type="submit" class="btn btn-sm btn-danger" title="Eliminar" onclick="return confirm('¿Está seguro de eliminar esta asignación?')">
                                            <i class="bx bx-trash-alt"></i> <!-- Icono de eliminar -->
                                            </button>
                                 	</form>
                            	    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#segment-users-table').DataTable({
             language: {
                url: '/js/i18n/es-MX.json'
        },
        pagingType: "simple_numbers",
        scrollX: true,
        dom: '<"top"f>rt<"bottom"lip><"clear">',
        bootstrap: true,
        paging: true,
        responsive: false, // Desactivar el responsive para evitar el botón de "+"
        autoWidth: false,

        });
    });
</script>
@endpush
