@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Asignar Hogar a Encuestador</h1>

    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('assignments.store') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label for="household_id" class="form-label">Seleccionar Hogar</label>
            <select class="form-control" id="household_id" name="household_id" required>
                @foreach($households as $household)
                    <option value="{{ $household->id }}">Segmento: {{ $household->correlativo_segmento }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="user_id" class="form-label">Seleccionar Encuestador</label>
            <select class="form-control" id="user_id" name="user_id" required>
                @foreach($surveyors as $surveyor)
                    <option value="{{ $surveyor->id }}">{{ $surveyor->name }}</option>
                @endforeach
            </select>
        </div>

        <button type="submit" class="btn btn-primary">Asignar Hogar</button>
    </form>
</div>
@endsection
