@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Agregar Condición</h1>

    <form action="{{ route('conditions.store') }}" method="POST">
        @csrf

        <!-- Tipo de condición -->
    <div class="form-group">
        <label for="condition_category">Tipo de Condición</label>
        <select name="condition_category" id="condition_category" class="form-control">
            <option value="option">Condición por Opción</option>
            <option value="validation">Condición de Validación</option>
        </select>
    </div>

    <!-- Pregunta que activa la condición -->
    <div class="form-group">
        <label for="question_id">Pregunta</label>
        <select name="question_id" id="question_id" class="form-control">
            @foreach($questions as $question)
                <option value="{{ $question->id }}">{{ $question->question_text }}</option>
            @endforeach
        </select>
    </div>

    <!-- Pregunta dependiente (solo se muestra si es Condición por Opción) -->
    <div class="form-group" id="dependent_question_group" style="display: none;">
        <label for="dependent_question_id">Pregunta Dependiente</label>
        <select name="dependent_question_id" id="dependent_question_id" class="form-control">
            @foreach($questions as $question)
                <option value="{{ $question->id }}">{{ $question->question_text }}</option>
            @endforeach
        </select>
    </div>

    <!-- Tipo de validación -->
    <div class="form-group">
        <label for="condition_type">Tipo de Validación</label>
        <select name="condition_type" id="condition_type" class="form-control">
            <option value="equals">Igual</option>
            <option value="not_equals">No igual</option>
            <option value="greater_than">Mayor que</option>
            <option value="less_than">Menor que</option>
            <option value="greater_or_equal">Mayor o igual que</option>
            <option value="less_or_equal">Menor o igual que</option>
        </select>
    </div>

    <!-- Valor de la condición -->
    <div class="form-group">
        <label for="condition_value">Valor de la Condición</label>
        <input type="text" name="condition_value" id="condition_value" class="form-control">
    </div>

        <button type="submit" class="btn btn-primary">Guardar Condición</button>
    </form>
</div>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const conditionCategory = document.getElementById('condition_category');
    const dependentQuestionGroup = document.getElementById('dependent_question_group');

    conditionCategory.addEventListener('change', function () {
        if (this.value === 'option') {
            // Mostrar la selección de la pregunta dependiente
            dependentQuestionGroup.style.display = 'block';
        } else {
            // Ocultar la selección de la pregunta dependiente
            dependentQuestionGroup.style.display = 'none';
        }
    });

    // Mostrar/ocultar al cargar la página, en caso de que ya haya una selección previa
    if (conditionCategory.value === 'option') {
        dependentQuestionGroup.style.display = 'block';
    } else {
        dependentQuestionGroup.style.display = 'none';
    }
});

</script>
@endsection
