@extends('layouts.main')

@section('content')
<div class="container">
    <h2>Crear Condiciones</h2>

    <!-- Seleccionar Pregunta -->
    <div class="form-group">
        <label for="question">Seleccionar Pregunta:</label>
        <select id="question" class="form-control">
            <option value="">Selecciona una pregunta</option>
            @foreach($questions as $question)
                <option value="{{ $question->id }}">{{ $question->question_text }}</option>
            @endforeach
        </select>
    </div>

    <!-- Contenedor para mostrar las condiciones existentes -->
    <div id="existing-conditions" style="display:none;">
        <h4>Condiciones existentes</h4>
        <ul id="conditions-list">
            <!-- Las condiciones existentes se cargarán aquí -->
        </ul>
    </div>

    <!-- Seleccionar criterio (all / any) -->
    <div class="form-group">
        <label for="criteria">Criterio de la condición:</label>
        <select id="criteria" class="form-control">
            <option value="all">La pregunta debe cumplir todos estos criterios</option>
            <option value="any">La pregunta debe cumplir alguno de estos criterios</option>
        </select>
    </div>

    <!-- Contenedor de formularios para nuevas condiciones -->
    <div id="new-condition-form"></div>

    <!-- Botón para añadir nueva condición -->
    <button type="button" id="add-condition" class="btn btn-primary">Añadir nueva condición</button>

    <!-- Botón para guardar condiciones -->
    <button type="button" id="save-conditions" class="btn btn-success">Guardar condiciones</button>
</div>

<!-- Plantilla de formulario de condición (se usará en JS) -->
<template id="condition-template">
    <div class="condition-form">
        <hr>
        <div class="form-group">
            <label for="condition_type">Tipo de condición:</label>
            <select class="form-control condition-type">
                <option value="option">Opción</option>
                <option value="validation">Validación</option>
            </select>
        </div>
        <!-- Campos para condición de tipo opción -->
        <div class="condition-option-fields" style="display:none;">
            <div class="form-group">
                <label for="dependent_question_id">Pregunta dependiente:</label>
                <select class="form-control dependent-question">
                    @foreach($questions as $question)
                        <option value="{{ $question->id }}">{{ $question->question_text }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label for="option_type">Tipo de opción:</label>
                <select class="form-control option-type">
                    <option value="equals">Igual a</option>
                    <option value="not_equals">Diferente a</option>
                    <option value="was_answered">Fue respondida</option>
                    <option value="not_answered">No fue respondida</option>
                </select>
            </div>
            <div class="form-group">
                <label for="option_value">Valor de la opción:</label>
                <input type="text" class="form-control option-value" placeholder="Valor de la opción">
            </div>
        </div>
        <!-- Campos para condición de tipo validación -->
        <div class="condition-validation-fields" style="display:none;">
            <div class="form-group">
                <label for="validation_type">Tipo de validación:</label>
                <select class="form-control validation-type">
                    <option value="equals">Igual a</option>
                    <option value="not_equals">Diferente a</option>
                    <option value="greater_than">Mayor que</option>
                    <option value="less_than">Menor que</option>
                </select>
            </div>
            <div class="form-group">
                <label for="validation_value">Valor de validación:</label>
                <input type="text" class="form-control validation-value" placeholder="Valor de la validación">
            </div>
        </div>
        <button type="button" class="btn btn-danger remove-condition">Eliminar condición</button>
    </div>
</template>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Al seleccionar una pregunta, obtener condiciones existentes
    document.getElementById('question').addEventListener('change', function() {
        const questionId = this.value;
        if (questionId) {
            fetch(`/conditions/get/${questionId}`)
                .then(response => response.json())
                .then(data => {
                    const conditionsList = document.getElementById('conditions-list');
                    conditionsList.innerHTML = '';
		    
		    // Revisar si hay condiciones de opcion o validacion
		    const optionConditions = data.optionConditions ||[];
		    const validationConditions = data.validationConditions ||[];

                    if (optionConditions.length > 0 || validationConditions.length > 0) {
                        // Mostrar condiciones de opción
                        optionConditions.forEach(condition => {
                            const li = document.createElement('li');
                            li.classList.add('condition-item');

                            let conditionText = `Condición: Opción - Pregunta Dependiente: ${condition.dependent_question_id} - Tipo de Opción: ${condition.option_type} - Valor de Opción: ${condition.option_value}`;
                            li.textContent = conditionText;

                            // Agregar un botón para eliminar la condición
                            const removeButton = document.createElement('button');
                            removeButton.textContent = 'Eliminar';
                            removeButton.classList.add('remove-condition', 'btn', 'btn-danger');
                            removeButton.addEventListener('click', function() {
                                if (confirm('¿Estás seguro de eliminar esta condición?')) {
                                    // Eliminar del servidor
                                    fetch(`/conditions/delete/${condition.id}`, {
                                        method: 'DELETE',
                                        headers: {
                                            'X-CSRF-TOKEN': '{{ csrf_token() }}', // Necesario si usas Laravel
                                            'Content-Type': 'application/json'
                                        }
                                    })
                                    .then(response => {
                                        if (response.ok) {
                                            // Eliminar visualmente si el servidor confirma la eliminación
                                            li.remove();
                                        } else {
                                            alert('Error al eliminar la condición');
                                        }
                                    })
                                    .catch(error => {
                                        console.error('Error al eliminar la condición:', error);
                                    });
                                }
                            });
                            li.appendChild(removeButton);

                            conditionsList.appendChild(li);
                        });
			// Mostrar condiciones de validación
                        validationConditions.forEach(condition => {
                            const li = document.createElement('li');
                            li.classList.add('condition-item');

                            let conditionText = `Condición: Validación - Tipo de Validación: ${condition.validation_type} - Valor de Validación: ${condition.validation_value}`;
                            li.textContent = conditionText;

                            // Agregar un botón para eliminar la condición
                            const removeButton = document.createElement('button');
                            removeButton.textContent = 'Eliminar';
                            removeButton.classList.add('remove-condition', 'btn', 'btn-danger');
                            removeButton.addEventListener('click', function() {
                                if (confirm('¿Estás seguro de eliminar esta condición?')) {
                                    // Eliminar del servidor
                                    fetch(`/conditions/delete/${condition.id}`, {
                                        method: 'DELETE',
                                        headers: {
                                            'X-CSRF-TOKEN': '{{ csrf_token() }}', // Necesario si usas Laravel
                                            'Content-Type': 'application/json'
                                        }
                                    })
                                    .then(response => {
                                        if (response.ok) {
                                            // Eliminar visualmente si el servidor confirma la eliminación
                                            li.remove();
                                        } else {
                                            alert('Error al eliminar la condición');
                                        }
                                    })
                                    .catch(error => {
                                        console.error('Error al eliminar la condición:', error);
                                    });
                                }
                            });
                            li.appendChild(removeButton);

                            conditionsList.appendChild(li);
                        });
                        document.getElementById('existing-conditions').style.display = 'block';
                    } else {
                        document.getElementById('existing-conditions').style.display = 'none';
                    }
                })
                .catch(error => {
                    console.error('Error al obtener las condiciones:', error);
                });
        } else {
            document.getElementById('existing-conditions').style.display = 'none';
        }
    });

    // Código para agregar nuevas condiciones dinámicamente
    document.getElementById('add-condition').addEventListener('click', function() {
    // Clonar la plantilla de condición
    const template = document.getElementById('condition-template').content.cloneNode(true);

    // Añadir la nueva condición al contenedor
    document.getElementById('new-condition-form').appendChild(template);

    // Seleccionar la última condición agregada (para agregar eventos de manera adecuada)
    const newConditionForm = document.querySelectorAll('.condition-form');
    const latestConditionForm = newConditionForm[newConditionForm.length - 1];

    // Lógica para manejar el cambio de tipo de condición (opción o validación)
    latestConditionForm.querySelector('.condition-type').addEventListener('change', function() {
        const optionFields = latestConditionForm.querySelector('.condition-option-fields');
        const validationFields = latestConditionForm.querySelector('.condition-validation-fields');
        
        if (this.value === 'option') {
            // Mostrar campos de opción y ocultar los de validación
            optionFields.style.display = 'block';
            validationFields.style.display = 'none';
        } else if (this.value === 'validation') {
            // Mostrar campos de validación y ocultar los de opción
            optionFields.style.display = 'none';
            validationFields.style.display = 'block';
        }
    });

    // Inicializar el valor inicial del tipo de condición (por defecto, "opción")
    const conditionType = latestConditionForm.querySelector('.condition-type').value;
    if (conditionType === 'option') {
        latestConditionForm.querySelector('.condition-option-fields').style.display = 'block';
        latestConditionForm.querySelector('.condition-validation-fields').style.display = 'none';
    } else {
        latestConditionForm.querySelector('.condition-option-fields').style.display = 'none';
        latestConditionForm.querySelector('.condition-validation-fields').style.display = 'block';
    }

    // Añadir evento para eliminar la condición
    latestConditionForm.querySelector('.remove-condition').addEventListener('click', function() {
        latestConditionForm.remove(); // Eliminar el formulario de condición actual
    });
});


    // Guardar las condiciones usando AJAX
    document.getElementById('save-conditions').addEventListener('click', function() {
        const questionId = document.getElementById('question').value;
        const criteria = document.getElementById('criteria').value;
        const conditionForms = document.querySelectorAll('.condition-form');

        let conditions = [];

        conditionForms.forEach(function(form) {
            const conditionType = form.querySelector('.condition-type').value;
            let condition = { type: conditionType };

            if (conditionType === 'option') {
                condition.dependent_question_id = form.querySelector('.dependent-question').value;
                condition.option_type = form.querySelector('.option-type').value;
                condition.option_value = form.querySelector('.option-value').value;
            } else if (conditionType === 'validation') {
                condition.validation_type = form.querySelector('.validation-type').value;
                condition.validation_value = form.querySelector('.validation-value').value;
            }

            conditions.push(condition);
        });

        fetch('{{ route('conditions.store') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                question_id: questionId,
                criteria: criteria,
                conditions: conditions
            })
        }).then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Condiciones guardadas correctamente');
                // Aquí puedes actualizar la lista de condiciones existentes sin recargar la página
            }
        });
    });
});
</script>
@endsection
