@extends('layouts.main')

@section('content')
<link rel="stylesheet" href="{{ asset('css/survey.css') }}">

<div class="container">
    <div class="form-container sections">
        <button class="nav-button" id="nav-toggle">
            <i class='bx bx-menu'></i> Navegación
        </button>

        <!-- Barra lateral -->
        <div class="sidebar" id="sidebar">
            <!-- Botón de cierre dentro de la barra lateral -->
            <button class="close-button" id="closeButton">
                <i class='bx bx-x'></i> Cerrar
            </button>

            <!-- Barra lateral dinámica -->
            @foreach($form->formSections as $section)
                <div class="section-header">
                    <a href="#section-{{ $section->id }}" class="section-link">
                        <i class='bx bx-chevron-right'></i> {{ $section->section_name }}
                    </a>
                    <i class="bx bx-chevron-down expand-btn"></i>
                </div>
                <div class="subsection" style="display: none;">
                    @foreach($section->questions as $question)
                        <a href="#question-{{ $question->id }}" class="question-link">
                            <i class='bx bx-right-arrow-alt'></i> {{ $question->question_text }}
                        </a>
                    @endforeach
                </div>
            @endforeach
        </div>

        <h2 class="tittle">{{ $form->form_name }}</h2> <!-- Nombre del formulario -->
        
        <!-- Formulario dinámico -->
        <form method="POST" id="form1" action="{{ route('survey.submit', ['form_id' => $form->id]) }}">
            @csrf

            <!-- Recorrer las secciones -->
            @foreach($form->formSections as $section)
                <div id="section-{{ $section->id }}" class="row sub survey-section">
                    <h3 class="subtitle">{{ $section->section_name }}</h3>
                </div>

                <!-- Fila dinámica para preguntas -->
                <div class="row">
                    @php $currentWidth = 0; @endphp
                    @foreach($section->questions->sortBy('question_order') as $question)
                        @php
                            // Obtener el ancho de columna según la clase de la pregunta
                            $columnWidth = preg_match('/col-md-(\d+)/', $question->style_class, $matches) ? $matches[1] : 0;
                            
                            // Si se excede el ancho máximo, crear una nueva fila
                            if ($currentWidth + $columnWidth > 12) {
                                echo '</div><div class="row">';
                                $currentWidth = 0;
                            }

                            // Acumular el ancho actual
                            $currentWidth += $columnWidth;
                        @endphp

                        <!-- Vista parcial de cada pregunta -->
                        @include('survey.partials.question_input', [
                            'question' => $question,
                            'sectionQuestion' => $sectionQuestions->where('section_id', $section->id)->firstWhere('question_id', $question->id)
                        ])
                    @endforeach
                </div> <!-- Cierre de fila actual -->
            @endforeach

            <!-- Botones de acciones -->
            <div class="text-end">
                <button type="button" id="save-draft" class="btn btn-secondary">Guardar Borrador</button>
                <button type="submit" class="btn btn-primary" id="submit-button">Enviar</button>
            </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Lógica para la barra lateral y expandir/cerrar secciones
        document.getElementById('nav-toggle').addEventListener('click', function() {
            var sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('open');
        });

        document.querySelectorAll('.expand-btn').forEach(function(btn) {
            btn.addEventListener('click', function() {
                var subsection = this.nextElementSibling;
                subsection.style.display = (subsection.style.display === "none") ? "block" : "none";
            });
        });

        document.getElementById('closeButton').addEventListener('click', function() {
            var sidebar = document.getElementById('sidebar');
            sidebar.classList.remove('open');
        });

        // Lógica para las condiciones de preguntas dependientes
        const conditions = @json($conditions);
        function updateQuestionVisibility() {
            conditions.forEach(condition => {
                const dependentQuestion = document.getElementById(`question-${condition.dependentQuestionId}`);
                const targetQuestion = document.getElementById(`question-${condition.questionId}`);

                if (!dependentQuestion || !targetQuestion) return;

                let selectedOption = dependentQuestion.querySelector('input[type="radio"]:checked')?.value || 
                                     dependentQuestion.querySelector('select')?.value;

                targetQuestion.style.display = (condition.optionType === 'equals' && selectedOption == condition.optionValue)
                    ? 'block' : 'none';
            });
        }
        document.querySelectorAll('input[type="radio"], select').forEach(input => input.addEventListener('change', updateQuestionVisibility));
        updateQuestionVisibility();

        // Validación de campos requeridos
        const submitButton = document.querySelector('button[type="submit"]');
        const requiredFields = document.querySelectorAll('[required]');

        function validateForm() {
            let allFilled = true;
            requiredFields.forEach(field => {
                if (!field.value) {
                    allFilled = false;
                    field.classList.add('is-invalid');
                } else {
                    field.classList.remove('is-invalid');
                }
            });
            submitButton.disabled = !allFilled;
        }
        requiredFields.forEach(field => field.addEventListener('input', validateForm));
        validateForm();
    });
</script>
@endsection
