@extends('layouts.main')

@section('content')
<link rel="stylesheet" href="{{ asset('css/survey.css') }}">

<div class="container">
    <div class="form-container sections">
        <button class="nav-button" id="nav-toggle">
            <i class='bx bx-menu'></i> Navegación
        </button>

        <!-- Barra lateral -->
        <div class="sidebar" id="sidebar">
            <!-- Botón de cierre dentro de la barra lateral -->
            <button class="close-button" id="closeButton">
                <i class='bx bx-x'></i> Cerrar
            </button>

            @foreach($form->formSections as $section)
                <div class="section-header">
                    <a href="#section-{{ $section->id }}" class="section-link">
                        <i class='bx bx-chevron-right'></i> {{ $section->section_name }}
                    </a>
                    <i class="bx bx-chevron-down expand-btn"></i>
                </div>
                <div class="subsection" style="display: none;">
                    @foreach($section->questions as $question)
                        <a href="#question-{{ $question->id }}" class="question-link">
                            <i class='bx bx-right-arrow-alt'></i> {{ $question->question_text }}
                        </a>
                    @endforeach
                </div>
            @endforeach
        </div>

        <h2 class="tittle">{{ $form->form_name }}</h2> <!-- Nombre del formulario -->
        <form method="POST" id="form1" action="{{ route('survey.submit', ['form_id' => $form->id]) }}">
            @csrf

            @foreach($form->formSections as $section)
                <div id="section-{{ $section->id }}" class="row sub survey-section">
                    <h3 class="subtitle">{{ $section->section_name }}</h3>
                </div>

  {{-- Nueva fila para preguntas de la sección --}}
                <div class="row">
                    @php $currentWidth = 0; @endphp
                    @foreach($section->questions->sortBy('question_order') as $index => $question)
                        @php
                            // Obtener el ancho de columna según la clase de la pregunta
                            $columnWidth = preg_match('/col-md-(\d+)/', $question->style_class, $matches) ? $matches[1] : 0;

                            // Verificar si el ancho acumulado más el siguiente excede el máximo (12 columnas)
                            if ($currentWidth + $columnWidth > 12) {
                                echo '</div><div class="row">'; // Cerrar la fila y abrir una nueva
                                $currentWidth = 0; // Reiniciar el acumulado
                            }

                            // Acumular ancho actual
                            $currentWidth += $columnWidth;
                        @endphp

                        {{-- Incluir la vista parcial para cada pregunta --}}
                        @include('survey.partials.question_input', [
                            'question' => $question,
                            'sectionQuestion' => $sectionQuestions->where('section_id', $section->id)->firstWhere('question_id', $question->id)
                        ])
                    @endforeach
                </div> <!-- Cierre de fila actual -->
            @endforeach

            <div class="text-end">
                <button type="button" id="save-draft" class="btn btn-secondary">Guardar Borrador</button>
                <button type="submit" class="btn btn-primary" id="submit-button">Enviar</button>
            </div>
        </form>
    </div>
</div>
<script>
    // Lógica para abrir y cerrar la barra lateral
        document.getElementById('nav-toggle').addEventListener('click', function() {
            var sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('open');
        });

        // Lógica para expandir y contraer las subsecciones
        document.querySelectorAll('.expand-btn').forEach(function(btn) {
            btn.addEventListener('click', function() {
		 var subsection = this.nextElementSibling;
                if (subsection.style.display === "none") {
                    subsection.style.display = "block";
                } else {
                    subsection.style.display = "none";
                }
            });
        });
        // Lógica para el botón de cierre de la barra lateral
        document.getElementById('closeButton').addEventListener('click', function() {
            var sidebar = document.getElementById('sidebar');
            sidebar.classList.remove('open');
        });
    function toggleOtherField(rowId) {
        const otherField = document.getElementById('other_field_' + rowId);
        otherField.style.display = otherField.style.display === 'none' ? 'block' : 'none';
    }
        const conditions = @json($conditions);
        console.log(conditions);

        document.addEventListener('DOMContentLoaded', function () {

        function updateQuestionVisibility() {
            conditions.forEach(condition => {
            const dependentQuestion = document.getElementById(`question-${condition.dependentQuestionId}`);
            const targetQuestion = document.getElementById(`question-${condition.questionId}`);

            if (!dependentQuestion || !targetQuestion) {
                return;
            }

            let selectedOption = null;

            // Obtener el valor seleccionado dependiendo del tipo de pregunta (radio, checkbox, select)
        if (dependentQuestion.querySelector('input[type="radio"]:checked')) {
                selectedOption = dependentQuestion.querySelector('input[type="radio"]:checked').value;
            } else if (dependentQuestion.querySelector('select')) {
                selectedOption = dependentQuestion.querySelector('select').value;
            }

            // Verificar si la condición se cumple y mostrar/ocultar la pregunta
            if (condition.optionType === 'equals' && selectedOption == condition.optionValue) {
                targetQuestion.style.display = 'block';
            } else {
		  targetQuestion.style.display = 'none';
            }
        });        // Llama a la función al cargar la página
        // Añadir un evento para actualizar la visibilidad cada vez que se cambie una opción en las preguntas dependientes
        }
        document.querySelectorAll('input[type="radio"], select').forEach(input => {
        input.addEventListener('change', updateQuestionVisibility);
    });
        updateQuestionVisibility();
    });
        // Required fields code
        document.addEventListener('DOMContentLoaded', function () {
            const submitButton = document.querySelector('button[type="submit"]');
            const requiredFields = document.querySelectorAll('[required]');

            function validateForm() {
                let allFilled = true;
                requiredFields.forEach(field => {
                    if (!field.value) {
                        allFilled = false;
                        field.classList.add('is-invalid');
                    } else {
                        field.classList.remove('is-invalid');
                    }
                });
                submitButton.disabled = !allFilled;
            }

            requiredFields.forEach(field => {
                field.addEventListener('input', validateForm);
            });

            validateForm(); // Ejecutar la validación al cargar la página
        });
</script>
@endsection
