@extends('layouts.main')
@section('content')
<link rel="stylesheet" href="{{ asset('css/survey.css') }}">

<div class="container">
    <div class="form-container sections">
    <form class="row g-3" id="household-visit-form">
        @csrf
        <!-- Campo oculto para enviar el form_id -->
        <input type="hidden" name="form_id" value="{{ $form_id }}">
        <div class="row sub survey-section">
            <h3 class="subtitle">DATOS DEL HOGAR A VISITAR</h3>
        </div>

        <!-- Correlativo del Segmento Cartográfico -->
        <div class="row">
        <div class="col-md-6">
            <label for="p1" class="form-label">Correlativo del Segmento Cartográfico</label>
            <select id="p1" name="p1" class="form-select select2" required>
                <option value="">Seleccione un segmento...</option>
                @foreach($segmentUser2 as $segment)
                    <option value="{{ $segment->correlativo_segmento }}">{{ $segment->correlativo_segmento }}</option>
                @endforeach
            </select>
        </div>

        <!-- Región de Salud -->
        <div class="col-md-6">
            <label for="p2" class="form-label">Región de Salud</label>
            <input type="text" id="p2" class="form-control" name="p2" readonly>
        </div>
        </div>
        <div class="row">

        <!-- Departamento -->
        <div class="col-md-6">
            <label for="p3" class="form-label">Departamento</label>
            <input type="text" id="p3" class="form-control" name="p3" readonly>
        </div>

        <!-- Municipio -->
        <div class="col-md-6">
            <label for="p4" class="form-label">Municipio</label>
            <input type="text" id="p4" class="form-control" name="p4" readonly>
        </div>
        </div>
        <div class="row">
        <!-- Distrito -->
        <div class="col-md-6">
            <label for="p5" class="form-label">Distrito</label>
            <input type="text" id="p5" class="form-control" name="p5" readonly>
        </div>

        <!-- Área -->
        <div class="col-md-6">
            <label for="p6" class="form-label">Área</label>
            <input type="text" id="p6" class="form-control" name="p6" readonly>
        </div>
        </div>
        <div class="row">
        <!-- Nombre de Supervisor de Gestión Local -->
        <div class="col-md-12">
            <label for="p7" class="form-label">Nombre de Supervisor de Gestión Local</label>
            <input type="text" id="p7" class="form-control" name="p7" value="{{ $user->name }}" readonly>
        </div>
        </div>
        <div class="row">
        <!-- Fecha de Visita y Levantamiento de Datos -->
        <div class="col-md-12">
            <label for="p8" class="form-label">Fecha de visita y levantamiento de datos</label>
            <input type="text" id="p8" class="form-control" name="p8" value="{{ $currentDate }}" readonly>
        </div>
        </div>
        <div class="row">
        <!-- Hora de Inicio -->
        <div class="col-md-6">
            <label for="p9" class="form-label">Hora de Inicio</label>
            <input type="text" id="p9" class="form-control" name="p9" value="{{ $currentTime }}" readonly>
        </div>
        <!-- Hora de Finalización -->
        <div class="col-md-6">
            <label for="p10" class="form-label">Hora de Finalización</label>
            <input type="text" id="p10" class="form-control" name="p10" readonly>
        </div>
	</div>
	<div class="row sub survey-section">
            <div class="col-lg-12">
            	<div class="pull-left">
                    <h3 class="subtitle">VERIFICACIÓN DE LISTADO DE MIEMBROS DEL HOGAR SELECCIONADOS</h3>
                </div>
                <div class="pull-right">
                    <button class="btn btn-outline-dark"  id="addHouseholds" ><i class='bx bxs-folder-plus'></i> Agregar hogar</button>
		    <button class="btn btn-outline-dark"  id="refreshHouseholds" ><i class='bx bx-repost'></i> Actualizar Hogares</button>
                </div>
            </div>
        </div>
	<!-- DataTable para mostrar los miembros del hogar -->
            <div class="row">
                <table id="household-table" class="table table-hover nowrap" style="width:100%">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Orden</th>
                            <th>No de casa</th>
                            <th>Miembros</th>
			    <th>Reside</th>
			    <th>Señal</th>
			    <th>Resultado</th>
			    <th>Estado</th>
            		    <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>
	<div class="col-12">
            <button type="submit" class="btn btn-primary">Guardar</button>
        </div>

    </form>
    </div>
</div>

<!-- Modal para ver los miembros del hogar -->
<div class="modal" id="membersModal" tabindex="-1" role="dialog" aria-labelledby="membersModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="membersModalLabel">Miembros del Hogar</h5>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered" id="members-table">
                    <thead>
                        <tr>
                            <th>Número de Línea</th>
                            <th>Grupo de edad</th>
                            <th>Nombre</th>
                            <th>Edad</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Aquí se cargarán los miembros del hogar -->
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal para detalles de miembros del hogar -->
<div class="modal" id="householdMemberModal" tabindex="-1" role="dialog" aria-labelledby="householdMemberModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="householdMemberModalLabel">Detalles de Miembro del Hogar</h5>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="householdMemberForm">
                    <div id="members-container"></div>
                </form>
            </div>
	    <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" onclick="saveHouseholdMembers()">Guardar Cambios</button>
            </div>

        </div>
    </div>
</div>

<div class="modal" id="replacementModal" tabindex="-1" role="dialog" aria-labelledby="replacementModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="replacementModalLabel">Sustituir Hogar</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Aquí se llenarán los hogares de reemplazo -->
                <ul id="replacementList" class="list-group">
                    <!-- Lista de hogares de reemplazo generada dinámicamente -->
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="signalModal" tabindex="-1" role="dialog" aria-labelledby="signalModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="signalModalLabel">Señal en el hogar</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Aquí se llenarán los hogares de reemplazo -->
                <ul id="replacementList" class="list-group">
                    <!-- Lista de hogares de reemplazo generada dinámicamente -->
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="resultModal" tabindex="-1" role="dialog" aria-labelledby="resultModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resultModalLabel">Señal en el hogar</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Aquí se llenarán los hogares de reemplazo -->
                <ul id="replacementList" class="list-group">
                    <!-- Lista de hogares de reemplazo generada dinámicamente -->
                </ul>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>

$(document).ready(function() {

    var householdTable = $('#household-table').DataTable({
        "scrollX": true,
	"language": {
		url: '//cdn.datatables.net/plug-ins/2.1.8/i18n/es-MX.json'
        },
	"columnDefs": [
		{
		"className": "dt-center",
		"targets": "_all"
		 }
	]
    });
    // Función para verificar si el usuario está asignado al hogar
    function checkHouseholdAssignment(householdId, userId, formId) {
    	return $.ajax({
            url: '/household-visit/check-assignment', // Cambia esta URL según tu ruta
            type: 'GET',
            data: {
            	household_id: householdId,
            	user_id: userId,
            	form_id: formId
            }
    	});
    }

    $('#refreshHouseholds').on('click', function(e) {
    	e.preventDefault(); // Prevenir cualquier comportamiento por defecto del botón

    	var segmentId = $('#p1').val();
    	var userId = {{ Auth::user()->id }};

    	// Asegúrate de que segmentId tiene un valor válido antes de cargar la tabla
    	if (segmentId) {
            loadHouseholdTable(segmentId, userId);
    	} else {
            console.log("Seleccione un segmento válido para actualizar la tabla.");
    	} 
    });
    // Función para cargar y actualizar el DataTable de hogares
    function loadHouseholdTable(segmentId, userId) {
    if (segmentId) {
        $.ajax({
            url: '/household-visit/segment-details/' + segmentId,
            type: 'GET',
            success: function(data) {
                // Actualizar los campos del segmento
                $('#p2').val(data.region);
                $('#p3').val(data.department);
                $('#p4').val(data.muni);
                $('#p5').val(data.distrito);
                $('#p6').val(data.area);

                // Limpiar y llenar el DataTable con los nuevos datos de hogares
                householdTable.clear().draw();
                $.each(data.households, function(index, household) {
                    checkHouseholdAssignment(household.id, userId, 2).done(function(isAssigned) {
                        // Comprobación para mostrar el estado y los botones correctamente
                        var resideButton, signalButton, resultButton, stateBadge, actionsDropdown;
			console.log('Household Data:', household);
                        // Lógica para manejar los botones y estados de cada hogar
                        switch (household.status) {
                            case 'available':
                                resideButton = '<button class="btn btn-sm btn-icon" onclick="Members(' + household.id + ')" data-toggle="tooltip" title="Reside en el hogar"><i class="bx bxs-file-blank" style="color:#07b500"></i></button>';
                                signalButton = '<button class="btn btn-sm btn-icon" onclick="Signal(' + household.id + ')" data-toggle="tooltip" title="Señal"><i class="bx bxs-file-blank" style="color:#07b500"></i></button>';
                                resultButton = '<button class="btn btn-sm btn-icon" onclick="Result(' + household.id + ')" data-toggle="tooltip" title="Resultado"><i class="bx bxs-file-blank" style="color:#07b500"></i></button>';
                                stateBadge = '<span class="badge badge-success">Disponible</span>';
                                actionsDropdown = '<a class="dropdown-item text-secondary" onclick="chooseHousehold(' + household.id + ')"><i class="bx bxs-hand-up mr-2"></i> Elegir</a>';
                                break;
                            case 'selected':
                                // Mostrar "Bloqueado" si el hogar está asignado a otro usuario
            			if (household.isBlocked) {
                                    resideButton = '<button class="btn btn-sm btn-icon" disabled data-toggle="tooltip" title="Hogar bloqueado"><i class="bx bxs-file-blank"></i></button>';
                                    signalButton = '<button class="btn btn-sm btn-icon" disabled data-toggle="tooltip" title="Hogar bloqueado"><i class="bx bxs-file-blank"></i></button>';
                                    resultButton = '<button class="btn btn-sm btn-icon" disabled data-toggle="tooltip" title="Hogar bloqueado"><i class="bx bxs-file-blank"></i></button>';
                                    stateBadge = '<span class="badge badge-secondary">Bloqueado</span>';
                                    actionsDropdown = '';
                                } else {
                                    resideButton = '<button type="button" class="btn btn-sm btn-icon" onclick="Members(' + household.id + ')" data-toggle="tooltip" title="Reside en el hogar"><i class="bx bx-file-blank" style="color:#0024FF"></i></button>';
                                    signalButton = '<button type="button" class="btn btn-sm btn-icon" onclick="Signal(' + household.id + ')" data-toggle="tooltip" title="Señal"><i class="bx bx-file-blank" style="color:#0024FF"></i></button>';
                                    resultButton = '<button type="button" class="btn btn-sm btn-icon" onclick="Result(' + household.id + ')" data-toggle="tooltip" title="Resultado"><i class="bx bx-file-blank" style="color:#0024FF"></i></button>';
                                    stateBadge = '<span class="badge badge-primary">Seleccionado</span>';
                                    actionsDropdown = '<a class="dropdown-item text-secondary" onclick="discardHousehold(' + household.id + ')"><i class="bx bxs-x-circle mr-2"></i> Descartar</a>';
                                }
                                break;
                            case 'complete':
                                resideButton = '<button class="btn btn-sm btn-icon" disabled data-toggle="tooltip" title="Hogar completo"><i class="bx bxs-file-blank"></i></button>';
                                signalButton = '<button class="btn btn-sm btn-icon" disabled data-toggle="tooltip" title="Hogar completo"><i class="bx bxs-file-blank"></i></button>';
                                resultButton = '<button class="btn btn-sm btn-icon" disabled data-toggle="tooltip" title="Hogar completo"><i class="bx bxs-file-blank"></i></button>';
                                stateBadge = '<span class="badge badge-success">Completo</span>';
                                actionsDropdown = ''; // Sin opciones
                                break;
                        }

                        // Agregar la fila al DataTable con la lógica aplicada
                        householdTable.row.add([
                            index + 1, // El número de fila
                            household.orden_vivienda || 'N/D', // Asignar 'N/D' si está vacío
                            household.numero_vivienda || 'N/D', // Asignar 'N/D' si está vacío
                            household.members || 'N/D', // Asignar 'N/D' si está vacío
                            resideButton,
                            signalButton,
                            resultButton,
                            stateBadge,
                            '<div class="dropdown">' +
                                '<button class="btn btn-sm btn-icon" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">' +
                                    '<i class="bx bx-dots-horizontal-rounded" data-toggle="tooltip" title="Acciones"></i>' +
                                '</button>' +
                                '<div class="dropdown-menu">' +
                                    '<a class="dropdown-item text-secondary" onclick="viewMembers(' + household.id + ')"><i class="bx bxs-show mr-2"></i> Ver información</a>' +
                                    actionsDropdown +
                                '</div>' +
                            '</div>'
                        ]).draw(false); // Agregar la fila al DataTable
                    });
                });
            },
            error: function(xhr) {
                console.log("Error al cargar los detalles del segmento: " + xhr.responseText);
            }
        });
    } else {  // Si no hay un segmento seleccionado, limpiar los campos y la tabla
        $('#p2, #p3, #p4, #p5, #p6').val('');
        householdTable.clear().draw(); // Limpiar la tabla
    }
    }
 

    // Evento de cambio en #p1 que llama a la función loadHouseholdTable
    $('#p1').change(function() {
    	var segmentId = $(this).val();
	var userId = {{ Auth::user()->id }}; // Obtiene el user_id

    	// Llamar a la función para cargar el DataTable
    	loadHouseholdTable(segmentId, userId);
    });

    window.chooseHousehold = function(householdId) {
    // Obtenemos el user_id y form_id de donde sea necesario. 
    var formId = 2;
    var estatus = 1; // O cualquier otro estado que desees asignar.
    var segmentId = $('#p1').val();

    $.ajax({
        url: '/household-visit/get-user-id', // Cambia esta URL a la ruta que usarás para obtener el user_id.
        method: 'GET',
        success: function(data) {
	    var userId = data.user_id; // Supongamos que el servidor devuelve el user_id.
	    
            // Ahora hacemos la solicitud para asignar el hogar.
            	$.ajax({
		    url: '/household-visit/assign-household', // Cambia esta URL según tu ruta.
                    method: 'POST',
                    data: {
            	    	household_id: householdId,
            	    	user_id: userId,
            	    	form_id: formId,
            	    	estatus: estatus,
            	    	_token: '{{ csrf_token() }}' // Incluye el token CSRF para protección.
            	    },
              	    success: function(response) {
            	    	// Manejar la respuesta después de la inserción
            	    	alert('Hogar elegido con éxito!');
            	    	// Opcionalmente, puedes actualizar el DataTable aquí
			loadHouseholdTable(segmentId, userId);

            	    },
            	    error: function(xhr) {
                    if (xhr.status === 403) {
                        // Manejar el caso cuando el hogar ya está asignado a otro usuario o ya está completo
                        alert(xhr.responseJSON.message); // Mostrar el mensaje de error recibido del servidor
                    } else {
                        console.log("Error al asignar el hogar: " + xhr.responseText);
                        alert('No se pudo asignar el hogar. Por favor, inténtalo nuevamente.');
                    }
                }
    	    	});
	 },
        error: function(xhr) {
            console.log("Error al obtener el user_id: " + xhr.responseText);
        }
    });
    }

    // Función para abrir el modal y cargar los datos de los miembros
    window.viewMembers = function(householdId) {
        $.ajax({
            url: '/household-visit/household-members/' + householdId,
            type: 'GET',
            success: function(data) {
                var membersHtml = '';
                $.each(data.members, function(index, member) {
                    membersHtml += '<tr>' +
                                    '<td>' + member.numero_de_linea + '</td>' +
                                    '<td>' + member.grupo_edad_texto + '</td>' +
                                    '<td>' + member.nombre + '</td>' +
                                    '<td>' + member.edad + '</td>' +
                                '</tr>';
                });
                $('#members-table tbody').html(membersHtml);
                $('#membersModal').modal('show');
            },
            error: function(xhr) {
                console.log("Error al cargar los miembros del hogar: " + xhr.responseText);
            }
        });
    }

    window.Members = function (householdId) {
    $.ajax({
        url: '/household-visit/household-members/' + householdId,
        method: 'GET',
        success: function(data) {
            var membersTableHtml = `
                <table class="table table-bordered">
                    <thead>
                        <tr>
			    <th>No línea</th>
			    <th>Grupo de edad</th>
                            <th>Nombre Completo</th>
                            <th>Edad</th>
                            <th>Sexo</th>
                            <th>Reside en el hogar actualmente</th>
			    <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody id="members-table-body">
            `;

            // Agregar cada miembro como una fila en la tabla
            $.each(data.members, function(index, member) {
                // Calcular la edad a partir de la fecha de nacimiento
                membersTableHtml += `
                    <tr data-member-id="${member.id}">
			<td> ${ member.numero_de_linea}</td>
			<td> ${ member.grupo_edad_texto} </td>
                        <td><input type="text" class="form-control member-name" value="${member.nombre} ${member.apellido}"></td>
                        <td><input type="number" class="form-control member-age" value="${member.edad}"></td>
                        <td>
                            <select class="form-control member-sex">
                                <option value="M" ${member.sex === 'M' ? 'selected' : ''}>Masculino</option>
                                <option value="F" ${member.sex === 'F' ? 'selected' : ''}>Femenino</option>
                            </select>
                        </td>
                        <td>
                            <select class="form-control member-resides-currently">
                                <option value="1" ${member.resides_currently ? 'selected' : ''}>Sí</option>
                                <option value="0" ${!member.resides_currently ? 'selected' : ''}>No</option>
                            </select>
                        </td>
                         <td>
                        </td>

                    </tr>
                `;
            });

            membersTableHtml += `
                    </tbody>
                </table>
                <button id="add-member-btn" class="btn btn-secondary">Agregar Miembro</button>
            `;

            // Insertar la tabla generada en el contenedor del modal
            $('#members-container').html(membersTableHtml);
            $('#householdMemberModal').modal('show');

            // Evento para agregar una nueva fila en la tabla para un nuevo miembro
            $('#add-member-btn').on('click', function() {
                $('#members-table-body').append(`
                    <tr class="new-member">
			<td> </td>
			 <td>
                            <select class="form-control member-group">
                                <option value="1">Madre o responsable</option>
                                <option value="2">0 a 4 años</option>
				<option value="3">5 a 7 años</option>
				<option value="4">8 a 11 años</option>
				<option value="5">12 a 17 años</option>
                            </select>
                        </td>
                        <td><input type="text" class="form-control member-name" placeholder="Nombre Completo"></td>
                        <td><input type="number" class="form-control member-age" placeholder="Edad"></td>
                        <td>
                            <select class="form-control member-sex">
                                <option value="1">Masculino</option>
                                <option value="2">Femenino</option>
                            </select>
                        </td>
                        <td>
                            <select class="form-control member-resides-currently">
                                <option value="1">Sí</option>
                                <option value="0">No</option>
                            </select>
                        </td>
                        <td><button class="btn btn-danger btn-sm remove-member-btn">Eliminar</button></td>
                    </tr>
                `);
            });

            // Evento para eliminar una fila de miembro
            $('#members-container').on('click', '.remove-member-btn', function() {
                $(this).closest('tr').remove();
            });
        },
        error: function(xhr) {
            console.log("Error al cargar los miembros del hogar: " + xhr.responseText);
        }
    });
    };

    window.Signal = function (householdId) {
    // Generar el contenido del formulario dinámico
    var formHtml = `
        <form id="signalForm">
            <div class="form-group">
                <label for="signalOptions">¿Qué señal pega en este hogar?</label>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="signal" id="signalClaro" value="Claro">
    1                    <label class="form-check-label" for="signalClaro">Claro</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="signal" id="signalTigo" value="Tigo">
                        <label class="form-check-label" for="signalTigo">Tigo</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="signal" id="signalDigicel" value="Digicel">
                        <label class="form-check-label" for="signalDigicel">Digicel</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="signal" id="signalMovistar" value="Movistar">
                        <label class="form-check-label" for="signalMovistar">Movistar</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="signal" id="signalOtro" value="Otro">
                        <label class="form-check-label" for="signalOtro">Otro</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="signal" id="signalNinguna" value="Ninguna">
                        <label class="form-check-label" for="signalNinguna">Ninguna</label>
                    </div>
                </div>
            </div>
            <button type="button" id="submitSignalBtn" class="btn btn-primary">Guardar</button>
        </form>
    `;

    // Insertar el contenido del formulario en el cuerpo del modal
    $('#replacementList').html(formHtml);

    // Mostrar el modal
    $('#signalModal').modal('show');

    // Manejar el evento de clic en el botón "Guardar"
    $('#submitSignalBtn').on('click', function () {
        var selectedSignal = $('input[name="signal"]:checked').val();
        if (!selectedSignal) {
            alert('Por favor, selecciona una señal.');
            return;
        }

        // Enviar la señal seleccionada al servidor con AJAX
        $.ajax({
            url: '/household/signal/' + householdId,
            method: 'POST',
            data: {
                signal: selectedSignal,
                _token: $('meta[name="csrf-token"]').attr('content') // Token CSRF para Laravel
            },
            success: function (response) {
                alert('Señal guardada con éxito: ' + selectedSignal);
                $('#signalModal').modal('hide'); // Cerrar el modal
            },
            error: function (xhr) {
                console.error("Error al guardar la señal: " + xhr.responseText);
                alert('Ocurrió un error al guardar la señal.');
            }
        });
    });
    };


    // Evento para guardar cambios
    $('#save-members-btn').on('click', function() {
    var membersData = [];

    // Recorrer cada fila y recopilar datos de miembros
    $('#members-table-body tr').each(function() {
        var memberId = $(this).data('member-id');
        var isNewMember = $(this).hasClass('new-member');

        var memberData = {
            id: memberId,
            nombre: $(this).find('.member-name').val(),
            age: $(this).find('.member-age').val(),
            sex: $(this).find('.member-sex').val(),
            resides_currently: $(this).find('.member-resides-currently').val(),
            is_new: isNewMember // Para identificar miembros nuevos
        };

        membersData.push(memberData);
    });

    // Enviar datos al servidor
    $.ajax({
        url: '/household-visit/save-household-members', // Ruta para guardar cambios
        method: 'POST',
        data: {
            members: membersData,
            household_id: householdId,
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            alert('Cambios guardados exitosamente.');
            $('#householdMemberModal').modal('hide'); // Cerrar el modal al finalizar
        },
        error: function(xhr) {
            console.error("Error al guardar los miembros: " + xhr.responseText);
        }
    });
    });

    window.discardHousehold = function (householdId) {
    	var userId = {{ Auth::user()->id }}; // Obtener el ID del usuario autenticado
	var segmentId = $('#p1').val(); // Obtener el segmentId actual

	$.ajax({
            url: '/household-visit/discard-household', // Cambia esta URL según la ruta en tu aplicación
            method: 'POST',
            data: {
              	household_id: householdId,
            	user_id: userId,
            	_token: '{{ csrf_token() }}' // Agregar token CSRF para seguridad
            },
            success: function(response) {
            	// Notificar al usuario que el hogar ha sido descartado
            	alert('Hogar descartado con éxito.');
            	// Opcionalmente, puedes actualizar el DataTable aquí
            	loadHouseholdTable(segmentId, userId);
            },
            error: function(xhr) {
            	console.error("Error al descartar el hogar: " + xhr.responseText);
            }
        });
    }
    window.ReplaceHousehold = function (segmentId) {
    // Cargar los hogares que pueden sustituir al seleccionado

        $.ajax({
            url: '/household-visit/get-replacements/' + segmentId,
            method: 'GET',
            success: function(replacements) {
                // Aquí puedes llenar la modal con los hogares de reemplazo
                 $('#replacementList').empty(); // Limpiar la lista de reemplazos

                // Llenar la lista de reemplazos
                $.each(replacements, function(index, replacement) {
                    $('#replacementList').append('<li class="list-group-item">' + replacement.orden_vivienda + ' (ID: ' + replacement.numero_vivienda + ')</li>');
                });

                $('#replacementModal').modal('show'); // Mostrar la ventana modal
            },
            error: function(xhr) {
                console.log("Error al cargar los hogares de sustitución: " + xhr.responseText);
            }
        });
    }

    $('#householdMemberForm').on('submit', function(event) {
    event.preventDefault();
    
    	var memberId = $('#householdMemberId').val();
    	var formData = {
        residesCurrently: $('#residesCurrently').val()
    	};
    
    	$.ajax({
            url: '/update-household-member/' + memberId,
            method: 'POST',
            data: formData,
            success: function(response) {
            	$('#householdMemberModal').modal('hide');
            	alert('Información guardada exitosamente');
            	// Puedes actualizar el DataTable si es necesario
            },
            error: function(xhr) {
            	console.error("Error al guardar la información: " + xhr.responseText);
            }
    	});
    });
    // Evento de cierre del modal
    $('#membersModal').on('hidden.bs.modal', function() {
        // Limpia el formulario al cerrar el modal
        $('#householdMemberForm')[0].reset();
    });
    $('#householdMemberModal').on('hidden.bs.modal', function() {
        // Limpia el formulario al cerrar el modal
        $('#householdMemberForm')[0].reset();
    });


    // Botón de Guardar Cambios
    $('#saveMemberInfo').click(function() {
       // Aquí puedes añadir lógica para guardar los datos ingresados
       $('#householdMemberModal').modal('hide'); // Cierra el modal al guardar cambios
    });
    
});
</script>
@endpush
