@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Editar Sección</h1>

    <form action="{{ route('form_sections.update', $formSection->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label for="form_id" class="form-label">Formulario</label>
            <select id="form_id" name="form_id" class="form-select" required>
                @foreach ($forms as $form)
                    <option value="{{ $form->id }}" {{ $form->id == $formSection->form_id ? 'selected' : '' }}>
                        {{ $form->form_name }}
                    </option>
                @endforeach
            </select>
            @error('form_id')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>
        <div class="mb-3">
            <label for="section_name" class="form-label">Nombre de la Sección</label>
            <input type="text" id="section_name" name="section_name" class="form-control" value="{{ $formSection->section_name }}" required>
        </div>
        <div class="mb-3">
            <label for="section_order" class="form-label">Orden</label>
            <input type="number" id="section_order" name="section_order" class="form-control" value="{{ $formSection->section_order }}" required>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Descripción</label>
            <textarea id="description" name="description" class="form-control">{{ $formSection->description }}</textarea>
        </div>
        <button type="submit" class="btn btn-primary">Actualizar</button>
    </form>
</div>
@endsection
