@extends('layouts.main') <!-- Asegúrate de que tienes un layout general -->

@section('content')
<div class="container">
    <h1>Listado de Preguntas</h1>
    <a href="{{ route('questions.create') }}" class="btn btn-primary">Create Question</a>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Texto de la Pregunta</th>
                <th>Tipo de Pregunta</th>
                <th>Obligatoria</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($questions as $question)
            <tr>
                <td>{{ $question->id }}</td>
                <td>{{ $question->question_text }}</td>
                <td>{{ ucfirst($question->question_type) }}</td>
                <td>{{ $question->is_required ? 'Sí' : 'No' }}</td>
                <td>
                    <a href="{{ route('questions.edit', $question->id) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('questions.destroy', $question->id) }}" method="POST" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('¿Estás seguro?')">Eliminar</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
