@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Preguntas en Secciones</h1>

    <!-- Botón para agregar nueva pregunta -->
    <a href="{{ route('section_questions.create') }}" class="btn btn-primary mb-3">Agregar Nueva Pregunta</a>

    <!-- Tabla de preguntas en secciones -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Sección</th>
                <th>Pregunta</th>
                <th>Orden</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($sectionQuestions as $sectionQuestion)
                <tr>
                    <td>{{ $sectionQuestion->id }}</td>
                    <td>{{ $sectionQuestion->section->section_name }}</td>
                    <td>{{ $sectionQuestion->question->question_text }}</td>
                    <td>{{ $sectionQuestion->question_order }}</td>
                    <td>
                        <!-- Botón para editar -->
                        <a href="{{ route('section_questions.edit', $sectionQuestion->id) }}" class="btn btn-sm btn-warning">Editar</a>

                        <!-- Botón para eliminar -->
                        <form action="{{ route('section_questions.destroy', $sectionQuestion->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('¿Estás seguro de que deseas eliminar esta pregunta de la sección?')">Eliminar</button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5">No hay preguntas en las secciones actualmente.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection

