<!-- resources/views/household_members/edit.blade.php -->



<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>Editar Miembro del Hogar</h1>
    <form method="POST" action="<?php echo e(route('household_members.update', $householdMember->id)); ?>">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="mb-3">
            <label for="household_id" class="form-label">Hogar</label>
            <select class="form-control" id="household_id" name="household_id" required>
                <?php $__currentLoopData = $households; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $household): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($household->id); ?>" <?php echo e($householdMember->household_id == $household->id ? 'selected' : ''); ?>>
                        <?php echo e($household->numero_vivienda); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="mb-3">
            <label for="numero_de_linea" class="form-label">Número de Línea</label>
            <input type="number" class="form-control" id="numero_de_linea" name="numero_de_linea" value="<?php echo e($householdMember->numero_de_linea); ?>" required>
        </div>
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre</label>
            <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo e($householdMember->nombre); ?>" required>
        </div>
        <div class="mb-3">
            <label for="apellido" class="form-label">Apellido</label>
            <input type="text" class="form-control" id="apellido" name="apellido" value="<?php echo e($householdMember->apellido); ?>" required>
        </div>
        <div class="mb-3">
            <label for="fecha_nacimiento" class="form-label">Fecha de Nacimiento</label>
            <input type="date" class="form-control" id="fecha_nacimiento" name="fecha_nacimiento" value="<?php echo e($householdMember->fecha_nacimiento->format('Y-m-d')); ?>" required>
        </div>
        <div class="mb-3">
            <label for="edad" class="form-label">Edad</label>
            <input type="date" class="form-control" id="edad" name="edad" value="<?php echo e($householdMember->edad->format('Y-m-d')); ?>" required>
        </div>
        <button type="submit" class="btn btn-primary">Actualizar Miembro</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EncuestaProject/resources/views/household_members/edit.blade.php ENDPATH**/ ?>