<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <div class="row">
            		<div class="col-lg-12 margin-tb">
            		    <div class="pull-left">
              		        <h2>Segmentos asignados a supervisor de gestión local</h2>
                	    </div>
                	    <div class="pull-right">
                		<a href="<?php echo e(route('segment_user.create')); ?>" class="btn btn-outline-dark">
		   	          <i class='bx bxs-user-plus'></i>  Asignar Segmento
        			</a>
                	    </div>
               		</div>
        	    </div>
                </div>

                <div class="card-body">
                    <table id="segment-users-table" class="table table-hover responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Correlativo Segmento</th>
                                <th>Nombre de coordinador</th>
                                <th>Fecha de asignación</th>
				<th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $segmentUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $segmentUser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><?php echo e($segmentUser->correlativo_segmento); ?></td>
                                    <td><?php echo e($segmentUser->user->name); ?></td>
                                    <td><?php echo e($segmentUser->created_at->format('d-m-Y H:i')); ?></td>
				    <td>
                                	<!-- Botón de Editar -->
                                	<a href="<?php echo e(route('segment-user.edit', $segmentUser->id)); ?>" class="btn btn-sm btn-warning" title="Editar">
                                	    <i class="bx bx-edit-alt"></i> <!-- Icono de editar -->
                                	</a>
                                
                                	<!-- Botón de Eliminar -->
                                	<form action="<?php echo e(route('segment-user.destroy', $segmentUser->id)); ?>" method="POST" style="display:inline-block;">
                                    	    <?php echo csrf_field(); ?>
                                    	    <?php echo method_field('DELETE'); ?>
                                    	    <button type="submit" class="btn btn-sm btn-danger" title="Eliminar" onclick="return confirm('¿Está seguro de eliminar esta asignación?')">
                                            <i class="bx bx-trash-alt"></i> <!-- Icono de eliminar -->
                                            </button>
                                 	</form>
                            	    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#segment-users-table').DataTable({
             language: {
                url: '/js/i18n/es-MX.json'
        },
        pagingType: "simple_numbers",
        scrollX: true,
        dom: '<"top"f>rt<"bottom"lip><"clear">',
        bootstrap: true,
        paging: true,
        responsive: false, // Desactivar el responsive para evitar el botón de "+"
        autoWidth: false,

        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EncuestaProject/resources/views/segment-user/index.blade.php ENDPATH**/ ?>