<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                <div class="row">
                    <div class="col-12">
                        <div id="segmentos">
                            <!-- Contenido de Hogares -->
                            <div class="row">
                                <div class="col-lg-12 margin-tb">
                                <div class="pull-left">
				    <h1>Listado de hogares</h1>
				</div>
				<div class="pull-right">
                                    <!-- Formulario de importación de Households -->
        			    <form action="<?php echo e(route('households.import')); ?>" method="POST" enctype="multipart/form-data">
        		    	        <?php echo csrf_field(); ?>
            				<div class="form-group">
            				    <label for="file">Importar Households</label>
            				    <input type="file" name="file" class="form-control">
            				</div>
            				<button type="submit" class="btn btn-success mt-2">Importar</button>
			            </form>
                                </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                </div>
                <div class="card-body">
    		    <table id="householdTable" class="table table-hover responsive nowrap" style="width:100%">
        		<thead>
            	    	   <tr>
                		<th>#</th>
                		<th>C. Segmento</th>
                		<th>Región</th>
                		<th>Depto</th>
                		<th>Municipio</th>
                		<th>Distrito</th>
                		<th>Área</th>
				<th>Dirección</th>
                		<th>Or Viv</th>
                		<th>No Viv</th>
				<th>Detalle</th>
                		<th>Acciones</th>
            		   </tr>
        		</thead>
        		<tbody>
            		    <?php $__currentLoopData = $households; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $household): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
           		    <tr>
                		<td><?php echo e($household->id); ?></td>
                		<td><?php echo e($household->correlativo_segmento); ?></td>
                		<td><?php echo e($household->region_de_salud); ?></td>
		                <td><?php echo e($household->departamento); ?></td>
		                <td><?php echo e($household->municipio); ?></td>
		                <td><?php echo e($household->distrito); ?></td>
        		        <td><?php echo e($household->area); ?></td>
				<td><?php echo e($household->direccion); ?></td>
		                <td><?php echo e($household->orden_vivienda); ?></td>
		                <td><?php echo e($household->numero_vivienda); ?></td>
				<td><?php echo e($household->replacement); ?></td>
		            	<td>
                    		    <a href="<?php echo e(route('households.edit', $household->id)); ?>" class="btn btn-warning"><i class='bx bx-edit'></i></a>
                    		    <form action="<?php echo e(route('households.destroy', $household->id)); ?>" method="POST" style="display:inline;">
                        	    	<?php echo csrf_field(); ?>
                             	    	<?php echo method_field('DELETE'); ?>
                        	    	<button type="submit" class="btn btn-danger"><i class='bx bx-trash'></i></button>
                    		    </form>
                		</td>
            		    </tr>
           		    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        		</tbody>
    		    </table>
		</div>
	    </div>
	</div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {

    $('#householdTable').DataTable({
        language: {
                url: '/js/i18n/es-MX.json'
        },
        pagingType: "simple_numbers",
        scrollX: true,
        dom: '<"top"f>rt<"bottom"lip><"clear">',
        bootstrap: true,
        paging: true,
        responsive: false, // Desactivar el responsive para evitar el botón de "+"
        autoWidth: false,
    });
});
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EncuestaProject/resources/views/households/index.blade.php ENDPATH**/ ?>