<!-- resources/views/household_teams/index.blade.php -->



<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>Household Teams</h1>
    <a href="<?php echo e(route('household_teams.create')); ?>" class="btn btn-primary mb-3">Asignar Segmento</a>

    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <table id="householdTeamsTable" class="display compact" style="width:100%" >
        <thead>
            <tr>
                <th>Correlativo Segmento</th>
                <th>Departamento</th>
                <th>Municipio</th>
                <th>Distrito</th>
                <th>Cantón</th>
                <th>Equipo</th>
                <th>Usuario</th>
                <th>Reasignaciones</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $segmentTeam; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segmentTeam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($segmentTeam->segment ? $segmentTeam->segment->correlativo_segmento : 'N/A'); ?></td>
                    <td><?php echo e($segmentTeam->segment ? $segmentTeam->segment->dpto : 'N/A'); ?></td>
                    <td><?php echo e($segmentTeam->segment ? $segmentTeam->segment->muni : 'N/A'); ?></td>
                    <td><?php echo e($segmentTeam->segment ? $segmentTeam->segment->distrito : 'N/A'); ?></td>
                    <td><?php echo e($segmentTeam->segment ? $segmentTeam->segment->canton : 'N/A'); ?></td>
                    <td><?php echo e($segmentTeam->team ? $segmentTeam->team->name : 'N/A'); ?></td>
                    <td><?php echo e($segmentTeam->user ? $segmentTeam->user->name : 'N/A'); ?></td>
		    <td><?php echo e($segmentTeam->reassignment_count); ?></td>
                    <td>
                         <a href="<?php echo e(route('household_teams.reassign', $segmentTeam->id)); ?>" class="btn btn-warning btn-sm"><i class='bx bx-repost'></i></a>
			 <a href="<?php echo e(route('household_teams.showReassignments', $segmentTeam->correlativo_segmento)); ?>" class="btn btn-info">
                            <i class='bx bx-info-circle'></i>
                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#householdTeamsTable').DataTable({
            responsive: true,
            autoWidth: false,
            language: {
                url: '//cdn.datatables.net/plug-ins/1.11.5/i18n/Spanish.json'
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EncuestaProject/resources/views/household_teams/index.blade.php ENDPATH**/ ?>