<?php $__env->startSection('content'); ?>
<div class="container">
    <h1 class="mt-4">Editar Asignación de Segmento</h1>
    
    <div class="card">
        <div class="card-body">
            <form action="<?php echo e(route('segment-user.update', $segmentUser->id)); ?>" method="POST" class="row g-3">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <!-- Correlativo Segmento -->
                <div class="col-md-6">
                    <label for="correlativo_segmento" class="form-label">Correlativo Segmento</label>
                    <select id="correlativo_segmento" name="correlativo_segmento" class="form-select" required>
                        <option value="">Seleccione un segmento</option>
                        <?php $__currentLoopData = $segments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($segment->correlativo_segmento); ?>" 
                                <?php echo e($segmentUser->correlativo_segmento == $segment->correlativo_segmento ? 'selected' : ''); ?>>
                                <?php echo e($segment->correlativo_segmento); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Coordinador -->
                <div class="col-md-6">
                    <label for="user_id" class="form-label">Coordinador</label>
                    <select id="user_id" name="user_id" class="form-select" required>
                        <option value="">Seleccione un coordinador</option>
                        <?php $__currentLoopData = $coordinators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coordinator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($coordinator->id); ?>" 
                                <?php echo e($segmentUser->user_id == $coordinator->id ? 'selected' : ''); ?>>
                                <?php echo e($coordinator->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
		<div class="col-md-12">
                      <label for="coordinacion" class="form-label">Segmento requiere información del Personal</label>
                      <select id="coordinacion" name="coordinacion" class="form-select" required>
                            <option value="">Seleccione un segmento</option>
                            	    <option value="<?php echo e($segmentUser->coordinacion); ?>"
                                	<option value="1" <?php echo e($segmentUser->coordinacion == 1 ? 'selected' : ''); ?>>Sí</option>
			                <option value="0" <?php echo e($segmentUser->coordinacion == 0 ? 'selected' : ''); ?>>No</option>
                            	    </option>

                      </select>
                 </div>

                <!-- Botones de Acción -->
                <div class="col-12 d-flex justify-content-end">
                    <a href="<?php echo e(route('segment_user.index')); ?>" class="btn btn-secondary me-2">Cancelar</a>
                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EncuestaProject/resources/views/segment-user/edit.blade.php ENDPATH**/ ?>